/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util.retry;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Predicate;
import vip.justlive.oxygen.core.exception.WrappedException;
import vip.justlive.oxygen.core.util.retry.Attempt;
import vip.justlive.oxygen.core.util.retry.TimeLimiter;

public class Retryer<T> {
    TimeLimiter<T> timeLimiter;
    Predicate<Attempt<T>> retryPredicate;
    Predicate<Attempt<T>> stopPredicate;
    Consumer<Attempt<T>> blockConsumer;
    List<Consumer<Attempt<T>>> retryListeners;
    List<Consumer<Attempt<T>>> failListeners;
    List<Consumer<Attempt<T>>> successListeners;

    public T call(Callable<T> callable) {
        long startTime = System.currentTimeMillis();
        long attemptNumbers = 0L;
        while (true) {
            Attempt attempt = this.attempt(callable, ++attemptNumbers, startTime);
            this.retryListeners.forEach(listener -> listener.accept(attempt));
            if (!this.retryPredicate.test(attempt)) {
                if (attempt.hasException()) {
                    this.failListeners.forEach(listener -> listener.accept(attempt));
                    return null;
                }
                this.successListeners.forEach(listener -> listener.accept(attempt));
                return attempt.getResult();
            }
            if (this.stopPredicate.test(attempt)) {
                this.failListeners.forEach(listener -> listener.accept(attempt));
                return null;
            }
            this.blockConsumer.accept(attempt);
        }
    }

    Attempt<T> attempt(Callable<T> callable, long attemptNumbers, long startTime) {
        Attempt attempt;
        try {
            T value = this.timeLimiter.call(callable);
            attempt = new Attempt<T>(attemptNumbers, value, System.currentTimeMillis() - startTime);
        }
        catch (WrappedException e) {
            attempt = new Attempt(attemptNumbers, (Exception)e.getException(), System.currentTimeMillis() - startTime);
        }
        return attempt;
    }
}

