/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util.timer;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import vip.justlive.oxygen.core.util.timer.Task;

public class Slot
implements Delayed {
    private final AtomicLong deadline = new AtomicLong(-1L);
    Task<?> head;
    Task<?> tail;

    static Slot[] createSlots(int ticks) {
        if (ticks <= 0) {
            throw new IllegalArgumentException("ticks must be greater than 0: " + ticks);
        }
        Slot[] sts = new Slot[ticks];
        for (int i = 0; i < sts.length; ++i) {
            sts[i] = new Slot();
        }
        return sts;
    }

    synchronized void addTask(Task<?> task) {
        if (this.head == null) {
            this.tail = task;
            this.head = this.tail;
        } else {
            this.tail.next = task;
            task.prev = this.tail;
            this.tail = task;
        }
        task.slot = this;
    }

    synchronized Task<?> remove(Task<?> task) {
        Task<?> next = task.next;
        if (task.prev != null) {
            task.prev.next = next;
        }
        if (task.next != null) {
            task.next.prev = task.prev;
        }
        if (task == this.head) {
            if (task == this.tail) {
                this.tail = null;
                this.head = null;
            } else {
                this.head = next;
            }
        } else if (task == this.tail) {
            this.tail = task.prev;
        }
        task.prev = null;
        task.next = null;
        task.slot = null;
        return next;
    }

    boolean setDeadline(long deadline) {
        return this.deadline.getAndSet(deadline) != deadline;
    }

    long getDeadline() {
        return this.deadline.get();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.deadline.get() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        Slot slot = (Slot)o;
        return Long.compare(this.deadline.get(), slot.deadline.get());
    }
}

