/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util.timer;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.LongUnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.config.ConfigFactory;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.util.CronExpression;
import vip.justlive.oxygen.core.util.RepeatRunnable;
import vip.justlive.oxygen.core.util.SecurityChecker;
import vip.justlive.oxygen.core.util.SecurityThreadPoolExecutor;
import vip.justlive.oxygen.core.util.ThreadFactoryBuilder;
import vip.justlive.oxygen.core.util.timer.PeriodTask;
import vip.justlive.oxygen.core.util.timer.Slot;
import vip.justlive.oxygen.core.util.timer.Task;
import vip.justlive.oxygen.core.util.timer.Wheel;

public class WheelTimer {
    private static final Logger log = LoggerFactory.getLogger(WheelTimer.class);
    private static final int STATE_INIT = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_SHUTDOWN = 2;
    private static final long POLL_TIMEOUT;
    private static final ThreadFactory FACTORY;
    private static final AtomicInteger COUNT;
    private final long duration;
    private final int wheelSize;
    private final ThreadPoolExecutor executor;
    private final SecurityChecker securityChecker = new SecurityChecker();
    private final AtomicInteger state = new AtomicInteger(0);
    private final DelayQueue<Slot> delayQueue = new DelayQueue();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private Wheel wheel;
    private final RepeatRunnable worker = new RepeatRunnable("wheel-timer-" + COUNT.getAndIncrement(), this::doWork);

    public WheelTimer(long duration, int wheelSize) {
        this(duration, wheelSize, 1);
    }

    public WheelTimer(long duration, int wheelSize, int taskPoolSize) {
        this(duration, wheelSize, taskPoolSize, FACTORY);
    }

    public WheelTimer(long duration, int wheelSize, int taskPoolSize, ThreadFactory factory) {
        if (taskPoolSize < 1) {
            throw new IllegalArgumentException("taskPoolSize must be greater than 0: " + taskPoolSize);
        }
        this.duration = duration;
        this.wheelSize = wheelSize;
        SecurityThreadPoolExecutor.PoolQueue queue = new SecurityThreadPoolExecutor.PoolQueue();
        SecurityThreadPoolExecutor pool = new SecurityThreadPoolExecutor(1, taskPoolSize, 120L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)queue, factory);
        queue.setPool(pool);
        this.executor = pool;
    }

    public void start() {
        int stateValue = this.state.get();
        if (stateValue != 0 && stateValue != 1) {
            throw new IllegalStateException("WheelTimer.state is illegal");
        }
        if (!this.state.compareAndSet(0, 1)) {
            return;
        }
        FACTORY.newThread(this.worker).start();
        this.worker.awaitRunning();
        this.wheel = new Wheel(this.duration, this.wheelSize, System.currentTimeMillis(), this.delayQueue);
        log.info("WheelTimer started");
    }

    public void shutdown() {
        this.securityChecker.checkPermission();
        if (!this.state.compareAndSet(1, 2) && !this.state.compareAndSet(0, 2) && this.state.get() != 2) {
            throw new IllegalStateException("WheelTimer.state is illegal");
        }
        this.executor.shutdown();
        this.worker.shutdown();
        this.delayQueue.forEach(slot -> {
            Task<?> task = slot.head;
            while (task != null) {
                task = slot.remove(task);
            }
        });
        this.delayQueue.clear();
        log.info("WheelTimer shutdown");
    }

    public boolean isShutdown() {
        return this.state.get() == 2;
    }

    public <T> ScheduledFuture<T> schedule(Callable<T> callable, long delay, TimeUnit unit) {
        long deadline = this.check(delay, unit);
        Task<T> task = new Task<T>(deadline, callable);
        this.addTaskInLock(task);
        return task;
    }

    public ScheduledFuture<Void> schedule(Runnable command, long delay, TimeUnit unit) {
        long deadline = this.check(delay, unit);
        Task<Void> task = new Task<Void>(deadline, command);
        this.addTaskInLock(task);
        return task;
    }

    public ScheduledFuture<Void> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduleWithDelay(command, initialDelay, unit, d -> d + unit.toMillis(period));
    }

    public ScheduledFuture<Void> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduleWithDelay(command, initialDelay, unit, d -> System.currentTimeMillis() + unit.toMillis(delay));
    }

    public ScheduledFuture<Void> scheduleWithDelay(Runnable command, long initialDelay, TimeUnit unit, LongUnaryOperator operator) {
        long deadline = this.check(initialDelay, unit);
        PeriodTask task = new PeriodTask(deadline, command, operator, this);
        this.addTaskInLock(task);
        return task;
    }

    public ScheduledFuture<Void> scheduleOnCron(Runnable command, String cron) {
        this.start();
        LongUnaryOperator operator = new CronExpression(cron).operator();
        long deadline = operator.applyAsLong(0L);
        if (deadline == Long.MIN_VALUE) {
            throw Exceptions.fail("cron doesn't have any match in the future");
        }
        PeriodTask task = new PeriodTask(deadline, command, operator, this);
        this.addTaskInLock(task);
        return task;
    }

    void addTask(Task<?> task) {
        if (!this.wheel.add(task) && !task.isCancelled()) {
            this.executor.execute(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() {
        Slot slot = null;
        try {
            slot = (Slot)this.delayQueue.poll(POLL_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (slot == null) {
            return;
        }
        this.readWriteLock.writeLock().lock();
        try {
            while (slot != null) {
                this.wheel.advanceClock(slot.getDeadline());
                Task<?> task = slot.head;
                while (task != null) {
                    Task<?> next = slot.remove(task);
                    if (!task.isCancelled()) {
                        this.addTask(task);
                    }
                    task = next;
                }
                slot = (Slot)this.delayQueue.poll();
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private void addTaskInLock(Task<?> task) {
        this.readWriteLock.readLock().lock();
        try {
            this.addTask(task);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private long check(long delay, TimeUnit unit) {
        this.start();
        long deadline = System.currentTimeMillis() + unit.toMillis(delay);
        if (delay > 0L && deadline < 0L) {
            deadline = Long.MAX_VALUE;
        }
        return deadline;
    }

    public SecurityChecker getSecurityChecker() {
        return this.securityChecker;
    }

    static {
        COUNT = new AtomicInteger();
        POLL_TIMEOUT = Long.parseLong(ConfigFactory.getProperty("wheel_timer.poll.timeout", "100"));
        FACTORY = new ThreadFactoryBuilder().setDaemon(true).setPriority(5).setNameFormat("wheel-task-%d").build();
    }
}

