/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.job;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.Plugin;
import vip.justlive.oxygen.core.config.ConfigFactory;
import vip.justlive.oxygen.core.config.CoreConf;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.util.ClassUtils;
import vip.justlive.oxygen.core.util.ThreadFactoryBuilder;
import vip.justlive.oxygen.core.util.timer.WheelTimer;
import vip.justlive.oxygen.ioc.IocPlugin;
import vip.justlive.oxygen.job.Job;
import vip.justlive.oxygen.job.Scheduled;

public class JobPlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(JobPlugin.class);
    private static final List<Job> SCHEDULED_JOBS = new ArrayList<Job>();
    private WheelTimer wheelTimer;

    public static int currentJobSize() {
        return SCHEDULED_JOBS.size();
    }

    public int order() {
        return -2147483618;
    }

    public void start() {
        this.init();
        this.parseJobs();
    }

    public void stop() {
        this.wheelTimer.shutdown();
        SCHEDULED_JOBS.clear();
    }

    private void init() {
        CoreConf config = (CoreConf)ConfigFactory.load(CoreConf.class);
        this.wheelTimer = new WheelTimer(1L, 60, config.getJobPoolSize().intValue(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat(config.getJobThreadFormat()).build());
    }

    private void parseJobs() {
        IocPlugin.beanStore().getBeans().forEach(bean -> ClassUtils.getMethodsAnnotatedWith(bean.getClass(), Scheduled.class).forEach(method -> this.handleMethod((Method)method, bean)));
    }

    private void handleMethod(Method method, Object bean) {
        Job job;
        try {
            job = new Job(bean, bean.getClass().getMethod(method.getName(), method.getParameterTypes()));
        }
        catch (NoSuchMethodException e) {
            throw Exceptions.wrap((Throwable)e);
        }
        Scheduled scheduled = method.getAnnotation(Scheduled.class);
        this.check(scheduled);
        if (scheduled.fixedDelay().length() > 0) {
            this.addFixedDelayJob(job, scheduled.fixedDelay(), scheduled.initialDelay());
        }
        if (scheduled.fixedRate().length() > 0) {
            this.addFixedRateJob(job, scheduled.fixedRate(), scheduled.initialDelay());
        }
        if (scheduled.cron().length() > 0) {
            this.addCronJob(job, scheduled.cron());
        }
        if (scheduled.onApplicationStart()) {
            this.addOnApplicationStartJob(job, scheduled.async());
        }
    }

    private void check(Scheduled scheduled) {
        boolean invalid;
        int count = 0;
        if (scheduled.fixedDelay().length() > 0) {
            ++count;
        }
        if (scheduled.fixedRate().length() > 0) {
            ++count;
        }
        if (scheduled.cron().length() > 0) {
            ++count;
        }
        boolean bl = invalid = count > 1 || count == 0 && !scheduled.onApplicationStart();
        if (invalid) {
            throw new IllegalArgumentException("Specify 'fixedDelay', 'fixedRate', 'onApplicationStart' or 'cron'");
        }
    }

    private void addFixedDelayJob(Job job, String fixedDelay, String initialDelay) {
        long fixedDelayVal = Long.parseLong(ConfigFactory.getPlaceholderProperty((String)fixedDelay));
        long initialDelayVal = 0L;
        if (initialDelay.length() > 0) {
            initialDelayVal = Long.parseLong(ConfigFactory.getPlaceholderProperty((String)initialDelay));
        }
        this.wheelTimer.scheduleWithFixedDelay((Runnable)job.configFixedDelay(fixedDelayVal, initialDelayVal), initialDelayVal, fixedDelayVal, TimeUnit.MILLISECONDS);
        this.addJob(job);
    }

    private void addFixedRateJob(Job job, String fixedRate, String initialDelay) {
        long fixedRateVal = Long.parseLong(ConfigFactory.getPlaceholderProperty((String)fixedRate));
        long initialDelayVal = 0L;
        if (initialDelay.length() > 0) {
            initialDelayVal = Long.parseLong(ConfigFactory.getPlaceholderProperty((String)initialDelay));
        }
        this.wheelTimer.scheduleAtFixedRate((Runnable)job.configFixedRate(fixedRateVal, initialDelayVal), initialDelayVal, fixedRateVal, TimeUnit.MILLISECONDS);
        this.addJob(job);
    }

    private void addCronJob(Job job, String cron) {
        cron = ConfigFactory.getPlaceholderProperty((String)cron);
        this.wheelTimer.scheduleOnCron((Runnable)job.configCron(cron), cron);
        this.addJob(job);
    }

    private void addOnApplicationStartJob(Job job, boolean async) {
        Job target = job.configOnApplicationStart(async);
        if (async) {
            this.wheelTimer.schedule((Runnable)target, 0L, TimeUnit.MILLISECONDS);
        } else {
            target.run();
        }
        this.addJob(target);
    }

    private void addJob(Job job) {
        if (log.isDebugEnabled()) {
            log.debug("add a job [{}]", (Object)job);
        }
        SCHEDULED_JOBS.add(job);
    }
}

