/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv;

import java.util.Hashtable;
import org.apache.xerces.impl.dv.DVFactoryException;
import org.apache.xerces.impl.dv.DatatypeValidator;

public abstract class DTDDVFactory {
    private static final String DEFAULT_FACTORY_CLASS = "org.apache.xerces.impl.dv.dtd.DTDDVFactoryImpl";
    private static String fFactoryClass = null;
    private static DTDDVFactory fFactoryInstance = null;

    public static final synchronized void setFactoryClass(String string) throws DVFactoryException {
        if (fFactoryInstance != null) {
            throw new DVFactoryException("Cannot set the class name now. The class name '" + fFactoryClass + "' is already used.");
        }
        fFactoryClass = string;
    }

    public static final synchronized DTDDVFactory getInstance() throws DVFactoryException {
        if (fFactoryInstance != null) {
            return fFactoryInstance;
        }
        try {
            if (fFactoryClass == null) {
                fFactoryClass = DEFAULT_FACTORY_CLASS;
            }
            fFactoryInstance = (DTDDVFactory)Class.forName(fFactoryClass).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DVFactoryException("DTD factory class " + fFactoryClass + " not found.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DVFactoryException("DTD factory class " + fFactoryClass + " found but cannot be loaded.");
        }
        catch (InstantiationException instantiationException) {
            throw new DVFactoryException("DTD factory class " + fFactoryClass + " loaded but cannot be instantiated (no empty public constructor?).");
        }
        catch (ClassCastException classCastException) {
            throw new DVFactoryException("DTD factory class " + fFactoryClass + " does not extend from DTDDVFactory.");
        }
        return fFactoryInstance;
    }

    protected DTDDVFactory() {
    }

    public abstract DatatypeValidator getBuiltInDV(String var1);

    public abstract Hashtable getBuiltInTypes();
}

