/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.psvi.XSAnnotation;
import org.apache.xerces.impl.xs.psvi.XSModelGroup;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;

public class XSModelGroupImpl
implements XSModelGroup {
    public static final short MODELGROUP_CHOICE = 101;
    public static final short MODELGROUP_SEQUENCE = 102;
    public static final short MODELGROUP_ALL = 103;
    public short fCompositor;
    public XSParticleDecl[] fParticles = null;
    public int fParticleCount = 0;
    private String fDescription = null;

    public boolean isEmpty() {
        int n = 0;
        while (n < this.fParticleCount) {
            if (!this.fParticles[n].isEmpty()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int minEffectiveTotalRange() {
        if (this.fCompositor == 101) {
            return this.minEffectiveTotalRangeChoice();
        }
        return this.minEffectiveTotalRangeAllSeq();
    }

    private int minEffectiveTotalRangeAllSeq() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fParticleCount) {
            n += this.fParticles[n2].minEffectiveTotalRange();
            ++n2;
        }
        return n;
    }

    private int minEffectiveTotalRangeChoice() {
        int n = 0;
        if (this.fParticles.length > 0) {
            n = this.fParticles[0].minEffectiveTotalRange();
        }
        int n2 = 1;
        while (n2 < this.fParticleCount) {
            int n3 = this.fParticles[n2].minEffectiveTotalRange();
            if (n3 < n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public int maxEffectiveTotalRange() {
        if (this.fCompositor == 101) {
            return this.maxEffectiveTotalRangeChoice();
        }
        return this.maxEffectiveTotalRangeAllSeq();
    }

    private int maxEffectiveTotalRangeAllSeq() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fParticleCount) {
            int n3 = this.fParticles[n2].maxEffectiveTotalRange();
            if (n3 == -1) {
                return -1;
            }
            n += n3;
            ++n2;
        }
        return n;
    }

    private int maxEffectiveTotalRangeChoice() {
        int n = 0;
        if (this.fParticles.length > 0 && (n = this.fParticles[0].minEffectiveTotalRange()) == -1) {
            return -1;
        }
        int n2 = 1;
        while (n2 < this.fParticleCount) {
            int n3 = this.fParticles[n2].maxEffectiveTotalRange();
            if (n3 == -1) {
                return -1;
            }
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public String toString() {
        if (this.fDescription == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.fCompositor == 103) {
                stringBuffer.append("all(");
            } else {
                stringBuffer.append('(');
            }
            if (this.fParticles.length > 0) {
                stringBuffer.append(this.fParticles[0].toString());
            }
            int n = 1;
            while (n < this.fParticleCount) {
                if (this.fCompositor == 101) {
                    stringBuffer.append('|');
                } else {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.fParticles[n].toString());
                ++n;
            }
            stringBuffer.append(')');
            this.fDescription = stringBuffer.toString();
        }
        return this.fDescription;
    }

    public void reset() {
        this.fCompositor = (short)102;
        this.fParticles = null;
        this.fParticleCount = 0;
        this.fDescription = null;
    }

    public short getType() {
        return 7;
    }

    public String getName() {
        return null;
    }

    public String getNamespace() {
        return null;
    }

    public short getCompositor() {
        if (this.fCompositor == 101) {
            return 2;
        }
        if (this.fCompositor == 102) {
            return 1;
        }
        return 3;
    }

    public XSObjectList getParticles() {
        return new XSObjectListImpl(this.fParticles, this.fParticleCount);
    }

    public XSAnnotation getAnnotation() {
        return null;
    }
}

