/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.signature.XMLSignatureException;
import org.w3c.dom.Element;

public class X509IssuerSerialResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$keys$keyresolver$implementations$X509IssuerSerialResolver == null ? (class$org$apache$xml$security$keys$keyresolver$implementations$X509IssuerSerialResolver = X509IssuerSerialResolver.class$("org.apache.xml.security.keys.keyresolver.implementations.X509IssuerSerialResolver")) : class$org$apache$xml$security$keys$keyresolver$implementations$X509IssuerSerialResolver).getName());
    static /* synthetic */ Class class$org$apache$xml$security$keys$keyresolver$implementations$X509IssuerSerialResolver;

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Can I resolve " + element.getTagName() + "?"));
        }
        X509Data x509Data = null;
        try {
            x509Data = new X509Data(element, string);
        }
        catch (XMLSignatureException xMLSignatureException) {
            log.debug((Object)"I can't");
            return false;
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.debug((Object)"I can't");
            return false;
        }
        if (x509Data == null) {
            log.debug((Object)"I can't");
            return false;
        }
        if (x509Data.containsIssuerSerial()) {
            return true;
        }
        log.debug((Object)"I can't");
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        try {
            if (storageResolver == null) {
                Object[] objectArray = new Object[]{"X509IssuerSerial"};
                KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
                log.info((Object)"", (Throwable)keyResolverException);
                throw keyResolverException;
            }
            X509Data x509Data = new X509Data(element, string);
            int n = x509Data.lengthIssuerSerial();
            while (storageResolver.hasNext()) {
                X509Certificate x509Certificate = storageResolver.next();
                XMLX509IssuerSerial xMLX509IssuerSerial = new XMLX509IssuerSerial(element.getOwnerDocument(), x509Certificate);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found Certificate Issuer: " + xMLX509IssuerSerial.getIssuerName()));
                    log.debug((Object)("Found Certificate Serial: " + xMLX509IssuerSerial.getSerialNumber().toString()));
                }
                for (int i = 0; i < n; ++i) {
                    XMLX509IssuerSerial xMLX509IssuerSerial2 = x509Data.itemIssuerSerial(i);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found Element Issuer:     " + xMLX509IssuerSerial2.getIssuerName()));
                        log.debug((Object)("Found Element Serial:     " + xMLX509IssuerSerial2.getSerialNumber().toString()));
                    }
                    if (xMLX509IssuerSerial.equals(xMLX509IssuerSerial2)) {
                        log.debug((Object)"match !!! ");
                        return x509Certificate;
                    }
                    log.debug((Object)"no match...");
                }
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.debug((Object)"XMLSecurityException", (Throwable)xMLSecurityException);
            throw new KeyResolverException("generic.EmptyMessage", xMLSecurityException);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

