/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.ToNumberStrategy;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.math.NumberUtils;
import xyz.erupt.core.config.EruptGsonExclusionStrategies;

public class GsonFactory
implements ToNumberStrategy {
    public static final double JS_MAX_NUMBER = 9.007199254740991E15;
    public static final double JS_MIN_NUMBER = -9.007199254740991E15;
    private static final GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").registerTypeAdapter(LocalDateTime.class, (src, typeOfSrc, context) -> new JsonPrimitive(src.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")))).registerTypeAdapter(LocalDate.class, (src, typeOfSrc, context) -> new JsonPrimitive(src.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")))).registerTypeAdapter(LocalDateTime.class, (json, type, jsonDeserializationContext) -> LocalDateTime.parse(json.getAsJsonPrimitive().getAsString(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).registerTypeAdapter(LocalDate.class, (json, type, jsonDeserializationContext) -> LocalDate.parse(json.getAsJsonPrimitive().getAsString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"))).registerTypeAdapter(Long.class, (src, type, jsonSerializationContext) -> GsonFactory.serializeSafeNumber(src)).registerTypeAdapter(Double.class, (src, type, jsonSerializationContext) -> GsonFactory.serializeDoubleValue(src)).registerTypeAdapter(BigDecimal.class, (src, type, jsonSerializationContext) -> GsonFactory.serializeSafeNumber(src)).setObjectToNumberStrategy((ToNumberStrategy)new GsonFactory()).serializeNulls().setExclusionStrategies(new ExclusionStrategy[]{new EruptGsonExclusionStrategies()});
    private static final Gson gson = gsonBuilder.create();

    private static JsonPrimitive serializeSafeNumber(Number src) {
        if (src.doubleValue() > 9.007199254740991E15 || src.doubleValue() < -9.007199254740991E15) {
            return new JsonPrimitive(src.toString());
        }
        return new JsonPrimitive(src);
    }

    private static JsonPrimitive serializeDoubleValue(Double src) {
        if (src > 9.007199254740991E15 || src < -9.007199254740991E15) {
            return new JsonPrimitive(new BigDecimal(src).toPlainString());
        }
        if (Math.abs(src - (double)src.longValue()) < Math.ulp(src)) {
            return new JsonPrimitive((Number)src.longValue());
        }
        return new JsonPrimitive(String.format("%.15g", src).replaceAll("\\.?0+$", ""));
    }

    public Number readNumber(JsonReader in) throws IOException {
        String value = in.nextString();
        if (NumberUtils.isCreatable((String)value) && value.endsWith(".0")) {
            value = value.substring(0, value.length() - 2);
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException var6) {
            try {
                Double d = Double.valueOf(value);
                if ((d.isInfinite() || d.isNaN()) && !in.isLenient()) {
                    throw new MalformedJsonException("JSON forbids NaN and infinities: " + d + "; at path " + in.getPreviousPath());
                }
                return d;
            }
            catch (NumberFormatException e) {
                throw new JsonParseException("Cannot parse " + value + "; at path " + in.getPreviousPath(), (Throwable)e);
            }
        }
    }

    public static GsonBuilder getGsonBuilder() {
        return gsonBuilder;
    }

    public static Gson getGson() {
        return gson;
    }
}

