/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.config;

import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.util.UrlPathHelper;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.prop.EruptProp;

@Configuration
@Component
public class MvcConfig
implements WebMvcConfigurer {
    private final EruptProp eruptProp;
    private final Set<String> gsonMessageConverterPackage = Stream.of("xyz.erupt", Gson.class.getPackage().getName()).collect(Collectors.toSet());

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        Optional.ofNullable(this.eruptProp.getGsonHttpMessageConvertersPackages()).ifPresent(it -> this.gsonMessageConverterPackage.addAll(Arrays.asList(it)));
        converters.add(0, (HttpMessageConverter<?>)new GsonHttpMessageConverter(GsonFactory.getGson()){

            protected boolean supports(Class<?> clazz) {
                for (String pack : MvcConfig.this.gsonMessageConverterPackage) {
                    if (!clazz.getName().startsWith(pack)) continue;
                    return super.supports(clazz);
                }
                return false;
            }
        });
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String uploadPath = this.eruptProp.getUploadPath().endsWith("/") ? this.eruptProp.getUploadPath() : this.eruptProp.getUploadPath() + "/";
        ResourceHandlerRegistration resourceHandlerRegistration = registry.addResourceHandler(new String[]{"/erupt-attachment/**"});
        if (uploadPath.startsWith("classpath:")) {
            resourceHandlerRegistration.addResourceLocations(new String[]{uploadPath});
        } else {
            resourceHandlerRegistration.addResourceLocations(new String[]{"file:" + uploadPath});
        }
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        UrlPathHelper helper = new UrlPathHelper();
        helper.setUrlDecode(false);
        helper.setDefaultEncoding(StandardCharsets.UTF_8.name());
        configurer.setUrlPathHelper(helper);
    }

    public MvcConfig(EruptProp eruptProp) {
        this.eruptProp = eruptProp;
    }
}

