/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.context;

import java.util.HashMap;
import java.util.Map;
import xyz.erupt.core.context.MetaErupt;
import xyz.erupt.core.context.MetaUser;

public class MetaContext {
    private static final ThreadLocal<MetaContext> threadLocal = InheritableThreadLocal.withInitial(() -> {
        MetaContext metaContext = new MetaContext();
        metaContext.setMetaErupt(new MetaErupt());
        metaContext.setMetaUser(new MetaUser());
        return metaContext;
    });
    private MetaErupt metaErupt;
    private MetaUser metaUser;
    private String token;
    private Map<String, Object> vars = new HashMap<String, Object>();

    public static void set(MetaContext metaContext) {
        threadLocal.set(metaContext);
    }

    public static MetaContext get() {
        return threadLocal.get();
    }

    public static MetaErupt getErupt() {
        return MetaContext.threadLocal.get().metaErupt;
    }

    public static MetaUser getUser() {
        return MetaContext.threadLocal.get().metaUser;
    }

    public static String getToken() {
        return MetaContext.threadLocal.get().token;
    }

    public static Map<String, Object> getVars() {
        return MetaContext.threadLocal.get().vars;
    }

    public static void register(MetaErupt metaErupt) {
        threadLocal.get().setMetaErupt(metaErupt);
    }

    public static void register(MetaUser metaUser) {
        threadLocal.get().setMetaUser(metaUser);
    }

    public static void registerToken(String token) {
        threadLocal.get().setToken(token);
    }

    public static void registerVar(String key, Object value) {
        MetaContext.threadLocal.get().vars.put(key, value);
    }

    public static void remove() {
        threadLocal.remove();
    }

    public MetaErupt getMetaErupt() {
        return this.metaErupt;
    }

    public MetaUser getMetaUser() {
        return this.metaUser;
    }

    public void setMetaErupt(MetaErupt metaErupt) {
        this.metaErupt = metaErupt;
    }

    public void setMetaUser(MetaUser metaUser) {
        this.metaUser = metaUser;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setVars(Map<String, Object> vars) {
        this.vars = vars;
    }
}

