/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller;

import com.google.gson.JsonObject;
import java.util.List;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.annotation.SceneEnum;
import xyz.erupt.annotation.fun.PowerObject;
import xyz.erupt.core.annotation.EruptRecordOperate;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.event.EruptAddEvent;
import xyz.erupt.core.event.EruptDeleteEvent;
import xyz.erupt.core.event.EruptEditEvent;
import xyz.erupt.core.invoke.DataProcessorManager;
import xyz.erupt.core.invoke.DataProxyInvoke;
import xyz.erupt.core.naming.EruptRecordNaming;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.service.EruptModifyService;
import xyz.erupt.core.service.EruptService;
import xyz.erupt.core.service.IEruptDataService;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.core.view.R;

@RestController
@RequestMapping(value={"/erupt-api/data/modify"})
public class EruptModifyController {
    private static final Logger log = LoggerFactory.getLogger(EruptModifyController.class);
    private final EruptService eruptService;
    private final EruptModifyService eruptModifyService;
    private final ApplicationEventPublisher applicationEventPublisher;

    @Transactional
    @PostMapping(value={"/{erupt}"})
    @EruptRecordOperate(value="INSERT", dynamicConfig=EruptRecordNaming.class)
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    public R<Void> addEruptData(@PathVariable(value="erupt") String erupt, @RequestBody JsonObject data) {
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        Erupts.powerLegal(eruptModel, PowerObject::isAdd);
        EruptApiModel eruptApiModel = EruptUtil.validateEruptValue(eruptModel, data);
        if (eruptApiModel.getStatus() == EruptApiModel.Status.ERROR) {
            return R.error(eruptApiModel.getMessage());
        }
        Object obj = this.eruptModifyService.eruptInsertDataProcess(eruptModel, data);
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.beforeAdd(obj));
        DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).addData(eruptModel, obj);
        this.eruptModifyService.modifyLog(eruptModel, "ADD", GsonFactory.getGson().toJson(obj));
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.afterAdd(obj));
        this.applicationEventPublisher.publishEvent(new EruptAddEvent<Object>(eruptModel.getClazz(), obj));
        return R.ok();
    }

    public void batchAddEruptData(EruptModel eruptModel, List<Object> list) {
        for (Object data : list) {
            DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.beforeAdd(data));
        }
        DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).batchAddData(eruptModel, list);
        for (Object obj : list) {
            this.eruptModifyService.modifyLog(eruptModel, "ADD", GsonFactory.getGson().toJson(obj));
            DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.afterAdd(obj));
            this.applicationEventPublisher.publishEvent(new EruptAddEvent<Object>(eruptModel.getClazz(), obj));
        }
    }

    @PostMapping(value={"/{erupt}/update"})
    @EruptRecordOperate(value="UPDATE", dynamicConfig=EruptRecordNaming.class)
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @Transactional
    public R<Void> updateEruptData(@PathVariable(value="erupt") String erupt, @RequestBody JsonObject data) {
        return this.putUpdateEruptData(erupt, data);
    }

    @PostMapping(value={"/{erupt}/delete"})
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @EruptRecordOperate(value="DELETE", dynamicConfig=EruptRecordNaming.class)
    @Transactional
    public R<Void> deleteEruptData(@PathVariable(value="erupt") String erupt, @RequestBody String[] ids) {
        return this.deleteEruptDataList(erupt, ids);
    }

    @Deprecated
    @PutMapping(value={"/{erupt}"})
    @EruptRecordOperate(value="UPDATE", dynamicConfig=EruptRecordNaming.class)
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @Transactional
    public R<Void> putUpdateEruptData(@PathVariable(value="erupt") String erupt, @RequestBody JsonObject data) {
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        Erupts.powerLegal(eruptModel, PowerObject::isEdit);
        EruptApiModel eruptApiModel = EruptUtil.validateEruptValue(eruptModel, data);
        if (eruptApiModel.getStatus() == EruptApiModel.Status.ERROR) {
            return R.error(eruptApiModel.getMessage());
        }
        this.eruptService.verifyIdPermissions(eruptModel, data.get(eruptModel.getErupt().primaryKeyCol()).getAsString());
        Object o = GsonFactory.getGson().fromJson(data.toString(), eruptModel.getClazz());
        EruptUtil.clearObjectDefaultValueByJson(o, data);
        Object old = DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).findDataById(eruptModel, ReflectUtil.findClassField(eruptModel.getClazz(), eruptModel.getErupt().primaryKeyCol()).get(o));
        Object realOld = eruptModel.getClazz().getConstructor(new Class[0]).newInstance(new Object[0]);
        BeanUtils.copyProperties((Object)old, realOld);
        Object obj = EruptUtil.dataTarget(eruptModel, o, old, SceneEnum.EDIT);
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.beforeUpdate(obj));
        DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).editData(eruptModel, obj);
        this.eruptModifyService.modifyLog(eruptModel, "EDIT", data.toString());
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.afterUpdate(obj));
        this.applicationEventPublisher.publishEvent(new EruptEditEvent<Object>(eruptModel.getClazz(), obj, realOld));
        return R.ok();
    }

    @Deprecated
    @DeleteMapping(value={"/{erupt}/{id}"})
    @EruptRecordOperate(value="DELETE", dynamicConfig=EruptRecordNaming.class)
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @Transactional
    public EruptApiModel deleteEruptData(@PathVariable(value="erupt") String erupt, @PathVariable(value="id") String id) {
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        Erupts.powerLegal(eruptModel, PowerObject::isDelete);
        this.eruptService.verifyIdPermissions(eruptModel, id);
        IEruptDataService dataService = DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz());
        Object obj = dataService.findDataById(eruptModel, EruptUtil.toEruptId(eruptModel, id));
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.beforeDelete(obj));
        dataService.deleteData(eruptModel, obj);
        this.eruptModifyService.modifyLog(eruptModel, "DELETE", id);
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.afterDelete(obj));
        this.applicationEventPublisher.publishEvent(new EruptDeleteEvent<Object>(eruptModel.getClazz(), obj));
        return EruptApiModel.successApi();
    }

    @Deprecated
    @DeleteMapping(value={"/{erupt}"})
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @EruptRecordOperate(value="DELETES", dynamicConfig=EruptRecordNaming.class)
    @Transactional
    public R<Void> deleteEruptDataList(@PathVariable(value="erupt") String erupt, @RequestParam(value="ids") String[] ids) {
        for (String id : ids) {
            EruptApiModel eruptApiModel = this.deleteEruptData(erupt, id);
            if (eruptApiModel.getStatus() != EruptApiModel.Status.ERROR) continue;
            return R.error(eruptApiModel.getMessage());
        }
        return R.ok();
    }

    public EruptModifyController(EruptService eruptService, EruptModifyService eruptModifyService, ApplicationEventPublisher applicationEventPublisher) {
        this.eruptService = eruptService;
        this.eruptModifyService = eruptModifyService;
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

