/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.module;

import xyz.erupt.annotation.Erupt;
import xyz.erupt.core.constant.MenuStatus;
import xyz.erupt.core.constant.MenuTypeEnum;

public class MetaMenu {
    private Long id;
    private String code;
    private String name;
    private MenuStatus status;
    private String type;
    private String value;
    private Integer sort;
    private String icon;
    private MetaMenu parentMenu;

    public static MetaMenu createRootMenu(String code, String name, String icon, Integer sort) {
        MetaMenu metaMenu = new MetaMenu();
        metaMenu.code = code;
        metaMenu.name = name;
        metaMenu.status = MenuStatus.OPEN;
        metaMenu.sort = sort;
        metaMenu.icon = icon;
        return metaMenu;
    }

    public static MetaMenu createSimpleMenu(String code, String name, String value, MetaMenu parent, Integer sort, String icon, String type, MenuStatus menuStatus) {
        MetaMenu metaMenu = new MetaMenu();
        metaMenu.code = code;
        metaMenu.name = name;
        metaMenu.status = menuStatus;
        metaMenu.type = type;
        metaMenu.value = value;
        metaMenu.sort = sort;
        metaMenu.parentMenu = parent;
        metaMenu.icon = icon;
        return metaMenu;
    }

    public static MetaMenu createSimpleMenu(String code, String name, String value, MetaMenu parent, Integer sort, String type) {
        return MetaMenu.createSimpleMenu(code, name, value, parent, sort, null, type, MenuStatus.OPEN);
    }

    public static MetaMenu createEruptClassMenu(Class<?> eruptClass, MetaMenu parent, Integer sort, MenuTypeEnum menuTypeEnum, MenuStatus menuStatus) {
        return MetaMenu.createSimpleMenu(eruptClass.getSimpleName(), eruptClass.getAnnotation(Erupt.class).name(), eruptClass.getSimpleName(), parent, sort, "", menuTypeEnum.getCode(), menuStatus);
    }

    public static MetaMenu createEruptClassMenu(Class<?> eruptClass, MetaMenu parent, Integer sort) {
        return MetaMenu.createEruptClassMenu(eruptClass, parent, sort, MenuTypeEnum.TABLE, MenuStatus.OPEN);
    }

    public static MetaMenu createEruptClassMenu(Class<?> eruptClass, MetaMenu parent, Integer sort, MenuStatus menuStatus) {
        return MetaMenu.createEruptClassMenu(eruptClass, parent, sort, MenuTypeEnum.TABLE, menuStatus);
    }

    public static MetaMenu createEruptClassMenu(Class<?> eruptClass, MetaMenu parent, Integer sort, MenuTypeEnum menuTypeEnum) {
        return MetaMenu.createEruptClassMenu(eruptClass, parent, sort, menuTypeEnum, MenuStatus.OPEN);
    }

    public Long getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public MenuStatus getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public Integer getSort() {
        return this.sort;
    }

    public String getIcon() {
        return this.icon;
    }

    public MetaMenu getParentMenu() {
        return this.parentMenu;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatus(MenuStatus status) {
        this.status = status;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setParentMenu(MetaMenu parentMenu) {
        this.parentMenu = parentMenu;
    }
}

