/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.operator;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import xyz.erupt.core.operator.DbOperatorExpr;
import xyz.erupt.core.operator.OperatorStringType;
import xyz.erupt.core.util.TypeUtil;

public enum OperatorDateType implements DbOperatorExpr
{
    TODAY("\u4eca\u5929"){

        @Override
        public String expr(String field, Object value) {
            return FUTURE_DAYS.expr(field, 0);
        }
    }
    ,
    FEW_DAYS("\u8fc7\u53bb N \u5929"){

        @Override
        public String expr(String field, Object value) {
            int days = TypeUtil.fetchInt(value);
            String start = LocalDate.now().minusDays(days).atStartOfDay().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            String end = LocalDate.now().atStartOfDay().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            return String.format("%s between '%s' and '%s'", field, start, end);
        }
    }
    ,
    FUTURE_DAYS("\u672a\u6765 N \u5929"){

        @Override
        public String expr(String field, Object value) {
            int days = TypeUtil.fetchInt(value);
            String start = LocalDate.now().plusDays(1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            String end = LocalDate.now().plusDays(days).atTime(LocalTime.MAX).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            return String.format("%s between '%s' and '%s'", field, start, end);
        }
    }
    ,
    RANGE("\u533a\u95f4"){

        @Override
        public String expr(String field, Object value) {
            ArrayList s = (ArrayList)value;
            return String.format("%s between '%s' and '%s'", field, s.get(0), (String)s.get(1) + " 23:59:59");
        }
    }
    ,
    GT("\u5927\u4e8e"){

        @Override
        public String expr(String field, Object value) {
            return String.format("%s > '%s'", field, OperatorDateType.parseDate(value.toString()));
        }
    }
    ,
    LT("\u5c0f\u4e8e"){

        @Override
        public String expr(String field, Object value) {
            return String.format("%s < '%s'", field, OperatorDateType.parseDate(value.toString()) + " 23:59:59");
        }
    }
    ,
    EGT("\u5927\u4e8e\u7b49\u4e8e"){

        @Override
        public String expr(String field, Object value) {
            return String.format("%s >= '%s'", field, OperatorDateType.parseDate(value.toString()));
        }
    }
    ,
    ELT("\u5c0f\u4e8e\u7b49\u4e8e"){

        @Override
        public String expr(String field, Object value) {
            return String.format("%s <= '%s'", field, OperatorDateType.parseDate(value.toString()) + " 23:59:59");
        }
    }
    ,
    NULL("\u4e3a\u7a7a"){

        @Override
        public String expr(String field, Object value) {
            return OperatorStringType.NULL.expr(field, value);
        }
    }
    ,
    NOT_NULL("\u975e\u7a7a"){

        @Override
        public String expr(String field, Object value) {
            return OperatorStringType.NOT_NULL.expr(field, value);
        }
    };

    private final String name;

    public static String parseDate(String date) {
        return date;
    }

    public String getName() {
        return this.name;
    }

    private OperatorDateType(String name) {
        this.name = name;
    }
}

