/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.operator;

import java.util.List;
import xyz.erupt.core.operator.DbOperatorExpr;
import xyz.erupt.core.operator.OperatorStringType;

public enum OperatorNumberType implements DbOperatorExpr
{
    EQ("\u7b49\u4e8e"){

        @Override
        public String expr(String field, Object value) {
            return String.format("%s = %s", field, value);
        }
    }
    ,
    NEQ("\u4e0d\u7b49\u4e8e"){

        @Override
        public String expr(String field, Object value) {
            return String.format("%s <> %s", field, value);
        }
    }
    ,
    GT("\u5927\u4e8e"){

        @Override
        public String expr(String field, Object value) {
            return String.format("%s > %s", field, value);
        }
    }
    ,
    LT("\u5c0f\u4e8e"){

        @Override
        public String expr(String field, Object value) {
            return String.format("%s < %s", field, value);
        }
    }
    ,
    EGT("\u5927\u4e8e\u7b49\u4e8e"){

        @Override
        public String expr(String field, Object value) {
            return String.format("%s >= %s", field, value);
        }
    }
    ,
    ELT("\u5c0f\u4e8e\u7b49\u4e8e"){

        @Override
        public String expr(String field, Object value) {
            return String.format("%s <= %s", field, value);
        }
    }
    ,
    RANGE("\u533a\u95f4"){

        @Override
        public String expr(String field, Object value) {
            List s = (List)value;
            return String.format("%s between %s and %s", field, s.get(0), s.get(1));
        }
    }
    ,
    NULL("\u4e3a\u7a7a"){

        @Override
        public String expr(String field, Object value) {
            return OperatorStringType.NULL.expr(field, value);
        }
    }
    ,
    NOT_NULL("\u975e\u7a7a"){

        @Override
        public String expr(String field, Object value) {
            return OperatorStringType.NOT_NULL.expr(field, value);
        }
    };

    private final String name;

    public String getName() {
        return this.name;
    }

    private OperatorNumberType(String name) {
        this.name = name;
    }
}

