/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.toolkit.service;

import com.google.gson.reflect.TypeToken;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import xyz.erupt.core.cache.EruptCache;
import xyz.erupt.core.config.GsonFactory;

@Component
public class EruptCacheRedis<V>
implements EruptCache<V> {
    private final StringRedisTemplate stringRedisTemplate;

    public V put(String key, V v, long ttl) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)GsonFactory.getGson().toJson(v), ttl, TimeUnit.MILLISECONDS);
        return v;
    }

    public V get(String key) {
        return (V)GsonFactory.getGson().fromJson((String)this.stringRedisTemplate.opsForValue().get((Object)key), new TypeToken<V>(){}.getType());
    }

    public void expire(String key, long ttl) {
        this.stringRedisTemplate.expire((Object)key, ttl, TimeUnit.MILLISECONDS);
    }

    public Long getExpire(String key) {
        return this.stringRedisTemplate.getExpire((Object)key);
    }

    public void delete(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    @Generated
    public EruptCacheRedis(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }
}

