/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.webscoket.service;

import jakarta.annotation.Resource;
import jakarta.websocket.Session;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.upms.service.EruptContextService;
import xyz.erupt.webscoket.channel.EruptChannelManager;
import xyz.erupt.webscoket.channel.SocketCommand;
import xyz.erupt.webscoket.model.EruptWsSessionModel;

@Service
public class EruptWebSocketService {
    @Resource
    private EruptContextService eruptContextService;

    public List<EruptWsSessionModel> getAllSession() {
        return EruptChannelManager.getAllSession();
    }

    public EruptWsSessionModel getCurrentSession() {
        return Optional.ofNullable(EruptChannelManager.getSession(this.eruptContextService.getCurrentToken())).orElseThrow(() -> new EruptWebApiRuntimeException("not found websocket session"));
    }

    public <T> void send(EruptWsSessionModel eruptWsSessionModel, SocketCommand command, T data) {
        for (Session session : eruptWsSessionModel.getSessions()) {
            session.getBasicRemote().sendText(GsonFactory.getGson().toJson(Arrays.asList(command.getCommand(), data)));
        }
    }

    public <T> void send(SocketCommand command, T data) {
        this.send(this.getCurrentSession(), command, data);
    }

    public void sendJsMessage(String message) {
        this.send(SocketCommand.JS, "window.msg.info('" + message + "')");
    }

    public void sendJsNotify(String title, String message) {
        this.send(SocketCommand.JS, String.format("window.notify.info('%s', '%s')", title, message));
    }
}

