/*
 * Decompiled with CFR 0.152.
 */
package nccloud.open.api.auto.token.cur.utils;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import nccloud.open.api.auto.token.cur.utils.Base64Util;
import nccloud.open.api.auto.token.cur.utils.KeysFactory;

public class Decryption {
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static String symDecrypt(String strkey, String src) throws Exception {
        String target = null;
        try {
            Key key = KeysFactory.getSymKey(strkey);
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            IvParameterSpec iv = new IvParameterSpec(strkey.substring(0, 16).getBytes());
            cipher.init(2, key, iv);
            byte[] decodeResult = cipher.doFinal(Base64Util.decryptBASE64(src));
            target = new String(decodeResult);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
            throw new Exception("\ufffd\ufffd\ufffd\ufffd\u02a7\ufffd\ufffd" + e.getMessage());
        }
        return target;
    }

    public static String priDecrypt(String priKey, String src) throws Exception {
        String target = null;
        try (ByteArrayOutputStream out = null;){
            try {
                Key key = KeysFactory.getPrivateKey(priKey);
                Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-256AndMGF1Padding");
                cipher.init(2, key, new OAEPParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec("SHA-256"), PSource.PSpecified.DEFAULT));
                byte[] data = Base64Util.decryptBASE64(src);
                int inputLen = data.length;
                out = new ByteArrayOutputStream();
                int offSet = 0;
                int i = 0;
                while (inputLen - offSet > 0) {
                    byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(data, offSet, 128) : cipher.doFinal(data, offSet, inputLen - offSet);
                    out.write(cache, 0, cache.length);
                    offSet = ++i * 128;
                }
                target = new String(out.toByteArray());
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                throw new Exception("\ufffd\ufffd\ufffd\ufffd\u02a7\ufffd\ufffd", e);
            }
        }
        return target;
    }
}

