/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.svn;

import br.com.jarch.svn.BaseSvn;
import br.com.jarch.svn.LogUtils;
import br.com.jarch.svn.SvnFachada;
import java.io.File;
import java.net.URL;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

class CheckoutSvn
extends BaseSvn {
    private static final long serialVersionUID = -8759154546425267411L;

    public CheckoutSvn(StringBuilder log, String login, String senha) {
        super(log, login, senha);
    }

    public void checkout(URL urlOrigem, File pastaTrabalho) throws SVNException {
        this.checkout(urlOrigem, pastaTrabalho, 0L);
    }

    public void checkout(URL urlOrigem, File pastaTrabalho, long revisaoDesejada) throws SVNException {
        this.logUtil.formatBegin(this.log, "CHECKOUT");
        SVNUpdateClient updateClient = this.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        updateClient.setEventHandler(new ISVNEventHandler(){

            public void checkCancelled() {
            }

            public void handleEvent(SVNEvent svnEvent, double arg1) {
                String mensagem = "CHECKOUT: " + svnEvent.getFile().getPath();
                SvnFachada.mensagemProcessamento = mensagem;
                CheckoutSvn.this.logUtil.formatMiddle(CheckoutSvn.this.log, mensagem);
                LogUtils.generate(mensagem);
                try {
                    Thread.sleep(2L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        SVNRevision revisao = revisaoDesejada == 0L ? SVNRevision.HEAD : SVNRevision.create((long)revisaoDesejada);
        long revision = updateClient.doCheckout(SVNURL.parseURIEncoded((String)urlOrigem.toString()), pastaTrabalho, revisao, revisao, SVNDepth.INFINITY, false);
        this.logUtil.formatMiddle(this.log, "Revis\u00e3o: " + revision);
        this.logUtil.formatEnd(this.log, "CHECKOUT");
    }
}

