/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.svn;

import br.com.jarch.svn.BaseSvn;
import br.com.jarch.svn.LogUtils;
import br.com.jarch.svn.SvnFachada;
import br.com.jarch.svn.SvnUtil;
import br.com.jarch.svn.UpdateSvn;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;

class CommitSvn
extends BaseSvn {
    private static final long serialVersionUID = -4534594889920110891L;
    private final List<String> listaFileConflit = new ArrayList<String>();
    private final Set<String> listFileIgnoreUser = new HashSet<String>();
    private final List<File> listFile = new ArrayList<File>();
    private List<Long> listRevision = new ArrayList<Long>();
    private transient ISVNStatusHandler isvnStatusHandler = status -> {
        String mensagem = status.getNodeStatus().toString().toUpperCase() + ": " + status.getFile().getAbsolutePath();
        SvnFachada.mensagemProcessamento = mensagem;
        boolean commitArquivo = true;
        if (this.listFileIgnoreUser.contains(status.getFile().getName())) {
            commitArquivo = false;
            mensagem = "IGNORADO: " + status.getFile();
        } else if (status.getNodeStatus().equals(SVNStatusType.STATUS_NORMAL) || status.getNodeStatus().equals(SVNStatusType.STATUS_INCOMPLETE)) {
            commitArquivo = false;
        } else if (status.isConflicted()) {
            LogUtils.generate(status.toString());
            this.listaFileConflit.add(status.getFile().getPath() + "\n");
            mensagem = "CONFLITO: " + status.getFile();
        } else if (SvnUtil.ignora(status.getFile())) {
            mensagem = "IGNORADO: " + status.getFile();
            commitArquivo = false;
        } else if (SVNStatusType.STATUS_UNVERSIONED.equals(status.getNodeStatus())) {
            this.getWCClient().doAdd(status.getFile(), true, false, false, SVNDepth.EMPTY, false, false);
            mensagem = "ADD: " + status.getFile();
        } else if (SVNStatusType.MISSING.equals(status.getNodeStatus()) || SVNStatusType.STATUS_MISSING.equals(status.getNodeStatus())) {
            this.getWCClient().doDelete(status.getFile(), true, false, false);
            mensagem = "DELETE_PHISICAL: " + status.getFile();
        }
        SvnFachada.mensagemProcessamento = mensagem;
        this.logUtil.formatMiddle(this.log, mensagem);
        if (commitArquivo) {
            this.listFile.add(status.getFile());
        }
    };
    private transient ISVNEventHandler eventHandlerCommit = new ISVNEventHandler(){

        public void checkCancelled() {
        }

        public void handleEvent(SVNEvent svnEvent, double arg1) {
            if (svnEvent.getFile() != null) {
                String mensagem = "COMMIT: " + svnEvent.getFile();
                SvnFachada.mensagemProcessamento = mensagem;
                CommitSvn.this.logUtil.formatMiddle(CommitSvn.this.log, mensagem);
            }
        }
    };

    public CommitSvn(StringBuilder log, String login, String senha) {
        super(log, login, senha);
    }

    public void commit(URL urlRepositorio, File pastaTrabalho, Collection<String> listaArquivoIgnora, String comentario) throws Exception {
        URL urlWorkingCopy;
        if (!this.existeRepositorio(urlRepositorio)) {
            throw new Exception("Reposit\u00f3rio " + urlRepositorio.toString() + " N\u00c3O Localizado ");
        }
        if (!pastaTrabalho.exists()) {
            throw new Exception("Pasta trabalho " + pastaTrabalho.getAbsolutePath() + " N\u00c3O Localizado ");
        }
        if (listaArquivoIgnora != null) {
            this.listFileIgnoreUser.addAll(listaArquivoIgnora);
        }
        if (!(urlWorkingCopy = this.getRepositorio(pastaTrabalho)).toURI().equals(urlRepositorio.toURI())) {
            throw new Exception(String.format("Working Copy %s n\u00e3o est\u00e1 apontando para URL %s", pastaTrabalho, urlRepositorio));
        }
        this.logUtil.formatBegin(this.log, "COMMIT");
        do {
            File[] arrayFile;
            this.listFile.clear();
            this.verificaConflito(pastaTrabalho);
            if (this.listFile.isEmpty()) {
                arrayFile = new File[]{pastaTrabalho};
            } else {
                arrayFile = new File[this.listFile.size()];
                int i = 0;
                for (File file : this.listFile) {
                    arrayFile[i++] = file;
                }
            }
            try {
                SVNCommitClient svnCommitClient = this.getCommitClient();
                svnCommitClient.setEventHandler(this.eventHandlerCommit);
                SVNCommitInfo svnCommitInfo = svnCommitClient.doCommit(arrayFile, false, comentario, null, null, false, true, SVNDepth.INFINITY);
                if (svnCommitInfo.getNewRevision() <= -1L) continue;
                this.listRevision.add(svnCommitInfo.getNewRevision());
            }
            catch (SVNException svnException) {
                if (svnException.getMessage().indexOf("is out of date") > -1) {
                    UpdateSvn updateSvn = new UpdateSvn(this.log, this.login, this.senha);
                    updateSvn.update(urlRepositorio, pastaTrabalho);
                    continue;
                }
                throw new Exception(svnException.getMessage());
            }
        } while (!this.listFile.isEmpty());
        this.logUtil.formatMiddle(this.log, "REVIS\u00c3O(\u00d5ES): " + this.listRevision.toString());
        this.logUtil.formatEnd(this.log, "COMMIT");
    }

    public void verificaConflito(File pastaTrabalho) throws Exception {
        if (!pastaTrabalho.exists()) {
            throw new Exception("Pasta trabalho " + pastaTrabalho.getAbsolutePath() + " N\u00c3O Localizado ");
        }
        this.listaFileConflit.clear();
        this.getStatusClient().doStatus(pastaTrabalho, SVNRevision.HEAD, SVNDepth.INFINITY, false, false, false, false, this.isvnStatusHandler, this.listaFileConflit);
        if (!this.listaFileConflit.isEmpty()) {
            throw new Exception("Existe(m) arquivo(s) em conflito em " + this.listaFileConflit.toString());
        }
    }
}

