/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.svn;

import br.com.jarch.svn.LogUtils;
import br.com.jarch.svn.OperationSystemUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;

public final class FileUtils {
    private static final int MIL_VINTE_QUATRO = 1024;

    private FileUtils() {
    }

    public static String correctFolderFormat(String value) {
        Object newValue = value.trim();
        if (OperationSystemUtils.windows()) {
            if (((String)(newValue = ((String)newValue).replace("/", "\\"))).charAt(((String)newValue).length() - 1) != '\\') {
                newValue = (String)newValue + "\\";
            }
        } else if (((String)(newValue = ((String)newValue).replace("\\", "/"))).charAt(((String)newValue).length() - 1) != '/') {
            newValue = (String)newValue + "/";
        }
        return newValue;
    }

    public static File folderTemporary() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static void copy(File arquivoOrigem, File arquivoDestino) throws IOException {
        FileUtils.copy(arquivoOrigem.getAbsolutePath(), arquivoDestino.getAbsolutePath());
    }

    public static void copy(String arquivoOrigem, String arquivoDestino) throws IOException {
        File origem = new File(arquivoOrigem);
        File destino = new File(arquivoDestino);
        try (FileOutputStream out = new FileOutputStream(destino);
             FileInputStream in = new FileInputStream(origem);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static void remove(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileUtils.remove(files[i]);
            }
        }
        if (!file.delete()) {
            throw new RuntimeException();
        }
    }

    public static void move(File arquivo, File pastaDestino) {
        Path arquivoOrigemPath = arquivo.toPath();
        Path pastaDestinoPath = new File(pastaDestino.getAbsolutePath() + "/" + arquivo.getName()).toPath();
        LogUtils.generate("MOVENDO " + arquivo.getAbsolutePath() + " PARA " + pastaDestinoPath.toString());
        try {
            Files.move(arquivoOrigemPath, pastaDestinoPath, new CopyOption[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        LogUtils.generate("MOVIDO " + arquivo.getAbsolutePath() + " PARA " + pastaDestinoPath.toString());
    }

    public static String extensao(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase(Locale.forLanguageTag("pt-BR"));
        }
        if (ext == null) {
            return "";
        }
        return ext;
    }

    public static String content(File arquivo) throws IOException {
        FileReader fileReader = new FileReader(arquivo);
        BufferedReader lerArq = new BufferedReader(fileReader);
        StringBuilder sb = new StringBuilder();
        String linha = lerArq.readLine();
        sb.append(linha + "\n");
        while (linha != null) {
            linha = lerArq.readLine();
            if (linha == null) continue;
            sb.append(linha + "\n");
        }
        fileReader.close();
        return sb.toString();
    }

    public static void save(File arquivo, String conteudo) throws IOException {
        PrintWriter pw = new PrintWriter(arquivo);
        pw.append(conteudo);
        pw.flush();
        pw.close();
    }

    public static void save(File arquivo, List<String> lista) throws IOException {
        PrintWriter pw = new PrintWriter(arquivo);
        for (String conteudo : lista) {
            pw.append(conteudo + "\n");
        }
        pw.flush();
        pw.close();
    }

    public static void save(File arquivo, InputStream is) {
        try (FileOutputStream os = new FileOutputStream(arquivo);){
            int read;
            byte[] bytes = new byte[1024];
            while ((read = is.read(bytes)) != -1) {
                ((OutputStream)os).write(bytes, 0, read);
            }
        }
        catch (IOException ex) {
            LogUtils.generate(ex);
        }
    }

    public static File createTemporary() throws IOException {
        return File.createTempFile("arch", "arch");
    }

    public static String removeExtension(File file) {
        int dot = file.getName().indexOf(46);
        return file.getName().substring(0, dot);
    }

    public static void saveUtf8(File file, List<String> dados) throws IOException {
        try (FileOutputStream os = new FileOutputStream(file);
             BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8));){
            for (String linha : dados) {
                out.write(linha + "\n");
            }
        }
    }

    public static void saveUsAscIi(File file, List<String> dados) throws IOException {
        try (FileOutputStream os = new FileOutputStream(file);
             BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.US_ASCII));){
            for (String linha : dados) {
                out.write(linha + "\n");
            }
        }
    }

    public static File getFile(byte[] bytes) throws IOException {
        File arquivoTemp = File.createTempFile("arch", "getFile");
        FileUtils.save(arquivoTemp, bytes);
        return arquivoTemp;
    }

    public static void save(File arquivo, byte[] bytes) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(arquivo);){
            fos.write(bytes);
            FileDescriptor fd = fos.getFD();
            fos.flush();
            fd.sync();
        }
    }
}

