/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.svn;

import java.text.SimpleDateFormat;
import java.util.Date;

public final class LogUtils {
    private static final String SEPARATOR = "########################################################################################\n";
    private static final int STACKTRACE_INITIAL = 2;
    private static final int STACKTRACE_FINAL = 3;
    private static int posicao = 2;

    private LogUtils() {
    }

    public static void start() {
        posicao = 3;
        LogUtils.generate("##### * * * I N I C I O * * * #####");
    }

    public static void end() {
        posicao = 3;
        LogUtils.generate("##### * * * F I M * * * #####");
    }

    public static void generate(String msg) {
        String nomeClasseChamador = LogUtils.clazzCall();
        String nomeMetodoChamador = LogUtils.methodCall();
        int linhaChamador = LogUtils.lineCall();
        LogUtils.generate(nomeClasseChamador, nomeMetodoChamador, linhaChamador, msg, true);
    }

    public static void generate() {
        String nomeClasseChamador = LogUtils.clazzCall();
        String nomeMetodoChamador = LogUtils.methodCall();
        int linhaChamador = LogUtils.lineCall();
        LogUtils.generate(nomeClasseChamador, nomeMetodoChamador, linhaChamador, "", true);
    }

    public static void warning(String descricao) {
        String nomeClasseChamador = LogUtils.clazzCall();
        String nomeMetodoChamador = LogUtils.methodCall();
        int linhaChamador = LogUtils.lineCall();
        LogUtils.generate(nomeClasseChamador, nomeMetodoChamador, linhaChamador, "\n########################################################################################\n########################################################################################\n####### ---> " + descricao + "\n########################################################################################\n########################################################################################\n", true);
    }

    public static void warning() {
        String nomeClasseChamador = LogUtils.clazzCall();
        String nomeMetodoChamador = LogUtils.methodCall();
        int linhaChamador = LogUtils.lineCall();
        LogUtils.generate(nomeClasseChamador, nomeMetodoChamador, linhaChamador, "\n########################################################################################\n########################################################################################\n#######\n########################################################################################\n########################################################################################\n", true);
    }

    public static void generate(Exception ex) {
        ex.printStackTrace();
    }

    public static void generateSilent(Exception ex) {
    }

    private static String methodCall() {
        Throwable thr = new Throwable();
        thr.fillInStackTrace();
        StackTraceElement[] ste = thr.getStackTrace();
        return ste[posicao].getMethodName();
    }

    private static String clazzCall() {
        Throwable thr = new Throwable();
        thr.fillInStackTrace();
        StackTraceElement[] ste = thr.getStackTrace();
        String retorno = ste[posicao].getClassName();
        if (retorno.contains(".")) {
            retorno = retorno.substring(retorno.lastIndexOf(46) + 1);
        }
        return retorno;
    }

    private static int lineCall() {
        Throwable thr = new Throwable();
        thr.fillInStackTrace();
        StackTraceElement[] ste = thr.getStackTrace();
        return ste[posicao].getLineNumber();
    }

    private static void generate(String clazz, String method, int row, String message, boolean showMessage) {
        if (showMessage) {
            System.out.println(LogUtils.timeLocal() + " - " + clazz + ":" + row + " - " + method + " - " + message);
        }
        posicao = 2;
    }

    private static String timeLocal() {
        return new SimpleDateFormat("HH:mm:ss").format(new Date());
    }
}

