/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.svn;

import br.com.jarch.svn.OperationSystemType;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;

public final class OperationSystemUtils {
    private OperationSystemUtils() {
    }

    public static boolean linux() {
        return OperationSystemUtils.getOperationSystem() == OperationSystemType.LINUX;
    }

    public static boolean windows() {
        return OperationSystemUtils.getOperationSystem() == OperationSystemType.WINDOWS;
    }

    public static String computerName() throws UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        return addr.getHostName();
    }

    public static String hostAddress() throws UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        return addr.getHostAddress();
    }

    public static OperationSystemType getOperationSystem() {
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase(Locale.ENGLISH).contains("windows")) {
            return OperationSystemType.WINDOWS;
        }
        return OperationSystemType.LINUX;
    }
}

