/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.svn;

import br.com.jarch.svn.BaseSvn;
import br.com.jarch.svn.SvnFachada;
import java.io.File;
import java.net.URL;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

class UpdateSvn
extends BaseSvn {
    private static final long serialVersionUID = 1196865122154368792L;

    public UpdateSvn(StringBuilder log, String login, String senha) {
        super(log, login, senha);
    }

    public void update(URL urlRepositorio, File pastaTrabalho) throws Exception {
        if (!this.existeRepositorio(urlRepositorio)) {
            throw new Exception("Reposit\u00f3rio " + urlRepositorio.toString() + " N\u00c3O Localizado ! ");
        }
        if (!pastaTrabalho.exists()) {
            throw new Exception("Pasta de trabalhado " + pastaTrabalho.getAbsolutePath() + " N\u00c3O Localizado ! ");
        }
        SVNUpdateClient updateClient = this.getUpdateClient();
        updateClient.setEventHandler(new ISVNEventHandler(){

            public void checkCancelled() {
            }

            public void handleEvent(SVNEvent svnEvent, double arg1) {
                String mensagem = "UPDATE: " + svnEvent.getFile().getPath();
                UpdateSvn.this.logUtil.formatMiddle(UpdateSvn.this.log, mensagem);
                SvnFachada.mensagemProcessamento = mensagem;
                try {
                    Thread.sleep(2L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        updateClient.setIgnoreExternals(false);
        this.logUtil.formatBegin(this.log, "UPDATE");
        long numeroRevisao = updateClient.doUpdate(pastaTrabalho, SVNRevision.HEAD, SVNDepth.INFINITY, true, true);
        this.logUtil.formatMiddle(this.log, "REVIS\u00c3O(\u00d5ES) " + numeroRevisao);
        this.logUtil.formatBegin(this.log, "FIM");
    }
}

