/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.core.mgmt;

import cn.authing.core.http.HttpCall;
import cn.authing.core.mgmt.MFAManagementClient;
import cn.authing.core.mgmt.ManagementClient;
import cn.authing.core.types.ISetTotpResp;
import cn.authing.core.types.ImportTotpParams;
import cn.authing.core.types.RestfulResponse;
import cn.authing.core.types.UserMfaStatus;
import cn.authing.core.types.UserMfaType;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0007\u0012\u0004\u0012\u00020\f0\u00062\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u000f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u0007\u0012\u0004\u0012\u00020\u00100\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcn/authing/core/mgmt/MFAManagementClient;", "", "client", "Lcn/authing/core/mgmt/ManagementClient;", "(Lcn/authing/core/mgmt/ManagementClient;)V", "getStatus", "Lcn/authing/core/http/HttpCall;", "Lcn/authing/core/types/RestfulResponse;", "Lcn/authing/core/types/UserMfaStatus;", "userId", "", "importTotp", "Lcn/authing/core/types/ISetTotpResp;", "options", "Lcn/authing/core/types/ImportTotpParams;", "unAssociateMfa", "", "type", "Lcn/authing/core/types/UserMfaType;", "java-core"})
public final class MFAManagementClient {
    @NotNull
    private final ManagementClient client;

    public MFAManagementClient(@NotNull ManagementClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
    }

    @NotNull
    public final HttpCall<RestfulResponse<UserMfaStatus>, UserMfaStatus> getStatus(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        String url = this.client.getHost() + "/api/v2/users/" + userId + "/mfa-bound";
        return this.client.createHttpGetCall$java_core(url, (TypeToken)new TypeToken<RestfulResponse<UserMfaStatus>>(){}, getStatus.2.INSTANCE);
    }

    @NotNull
    public final HttpCall<RestfulResponse<Boolean>, Boolean> unAssociateMfa(@NotNull String userId, @NotNull UserMfaType type) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String url = this.client.getHost() + "/api/v2/users/" + userId + "/mfa-bound?type=" + (Object)((Object)type);
        return this.client.createHttpDeleteCall$java_core(url, (TypeToken)new TypeToken<RestfulResponse<Boolean>>(){}, unAssociateMfa.2.INSTANCE);
    }

    @NotNull
    public final HttpCall<RestfulResponse<ISetTotpResp>, ISetTotpResp> importTotp(@NotNull ImportTotpParams options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String url = this.client.getHost() + "/api/v2/mfa/totp/import";
        String string = new Gson().toJson((Object)options);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Gson().toJson(options)");
        return this.client.createHttpPostCall$java_core(url, string, (TypeToken)new TypeToken<RestfulResponse<ISetTotpResp>>(){}, importTotp.2.INSTANCE);
    }
}

