/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.core.common;

import cn.authing.core.Utils;
import cn.authing.core.common.CommonMethodClient;
import cn.authing.core.http.HttpCall;
import cn.authing.core.mgmt.ManagementClient;
import cn.authing.core.types.HttpRequestParam;
import cn.authing.core.types.MethodEnum;
import cn.authing.core.types.RestfulResponse;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00070\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcn/authing/core/common/CommonMethodClient;", "", "client", "Lcn/authing/core/mgmt/ManagementClient;", "(Lcn/authing/core/mgmt/ManagementClient;)V", "commonHttpClient", "Lcn/authing/core/http/HttpCall;", "Lcn/authing/core/types/RestfulResponse;", "options", "Lcn/authing/core/types/HttpRequestParam;", "java-core"})
public final class CommonMethodClient {
    @NotNull
    private final ManagementClient client;

    public CommonMethodClient(@NotNull ManagementClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
    }

    @NotNull
    public final HttpCall<RestfulResponse<Object>, RestfulResponse<Object>> commonHttpClient(@NotNull HttpRequestParam options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        MethodEnum method = options.getMethod();
        String url = this.client.getHost() + options.getUrl();
        if (MethodEnum.GET.equals((Object)method)) {
            return this.client.createHttpGetCall$java_core(new Utils().getQueryUrl(url, options.getParams()), (TypeToken)new TypeToken<RestfulResponse<Object>>(){}, commonHttpClient.2.INSTANCE);
        }
        if (MethodEnum.POST.equals((Object)method)) {
            String string = new GsonBuilder().create().toJson(options.getParams());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GsonBuilder().create().toJson(options.params)");
            return this.client.createHttpPostCall$java_core(url, string, (TypeToken)new TypeToken<RestfulResponse<Object>>(){}, commonHttpClient.4.INSTANCE);
        }
        if (MethodEnum.PUT.equals((Object)method)) {
            String string = new GsonBuilder().create().toJson(options.getParams());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GsonBuilder().create().toJson(options.params)");
            return this.client.createHttpPutCall$java_core(url, string, (TypeToken)new TypeToken<RestfulResponse<Object>>(){}, commonHttpClient.6.INSTANCE);
        }
        if (MethodEnum.DELETE.equals((Object)method)) {
            return this.client.createHttpDeleteCall$java_core(url, (TypeToken)new TypeToken<RestfulResponse<Object>>(){}, commonHttpClient.8.INSTANCE);
        }
        throw new Exception("\u62b1\u6b49\uff0c\u76ee\u524d\u6682\u4e0d\u652f\u6301\u5bf9\u5e94\u7684\u8bf7\u6c42\u65b9\u5f0f\uff0c\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u5f0f\u6709\uff1aPOST/GET/PUT/DELETE");
    }
}

