/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.container;

import cn.crane4j.annotation.ContainerConstant;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ImmutableMapContainer;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.SimpleAnnotationFinder;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.ObjectUtils;
import cn.crane4j.core.util.ReflectUtils;
import cn.crane4j.core.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConstantContainerBuilder {
    private final @NonNull Class<?> constantClass;
    private @Nullable Boolean onlyPublic = null;
    private @Nullable Boolean onlyExplicitlyIncluded = null;
    private @Nullable Boolean reverse = null;
    private @Nullable String namespace = null;
    private @NonNull AnnotationFinder annotationFinder = SimpleAnnotationFinder.INSTANCE;

    private ConstantContainerBuilder(@NonNull Class<?> constantClass) {
        this.constantClass = Objects.requireNonNull(constantClass, "constantClass must not null");
    }

    public static ConstantContainerBuilder of(@NonNull Class<?> constantClass) {
        return new ConstantContainerBuilder(constantClass);
    }

    public ConstantContainerBuilder annotationFinder(@NonNull AnnotationFinder annotationFinder) {
        this.annotationFinder = annotationFinder;
        return this;
    }

    public ConstantContainerBuilder onlyPublic(boolean onlyPublic) {
        this.onlyPublic = onlyPublic;
        return this;
    }

    public ConstantContainerBuilder onlyExplicitlyIncluded(boolean onlyExplicitlyIncluded) {
        this.onlyExplicitlyIncluded = onlyExplicitlyIncluded;
        return this;
    }

    public ConstantContainerBuilder reverse(boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    public ConstantContainerBuilder namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public Container<Object> build() {
        ContainerConstant annotation = this.annotationFinder.getAnnotation(this.constantClass, ContainerConstant.class);
        if (annotation != null) {
            if (this.onlyPublic == null) {
                this.onlyPublic = annotation.onlyPublic();
            }
            if (this.onlyExplicitlyIncluded == null) {
                this.onlyExplicitlyIncluded = annotation.onlyExplicitlyIncluded();
            }
            if (this.reverse == null) {
                this.reverse = annotation.reverse();
            }
            if (this.namespace == null) {
                this.namespace = annotation.namespace();
            }
        }
        boolean isOnlyPublic = ObjectUtils.defaultIfNull(this.onlyPublic, true);
        boolean isOnlyExplicitlyIncluded = ObjectUtils.defaultIfNull(this.onlyExplicitlyIncluded, false);
        boolean isReverse = ObjectUtils.defaultIfNull(this.reverse, false);
        Predicate<Field> fieldFilter = field -> Modifier.isStatic(field.getModifiers());
        if (isOnlyPublic) {
            fieldFilter = fieldFilter.and(field -> Modifier.isPublic(field.getModifiers()));
        }
        if (isOnlyExplicitlyIncluded) {
            fieldFilter = fieldFilter.and(field -> this.annotationFinder.hasAnnotation((AnnotatedElement)field, (Class<? extends Annotation>)ContainerConstant.Include.class));
        }
        fieldFilter = fieldFilter.and(field -> !this.annotationFinder.hasAnnotation((AnnotatedElement)field, (Class<? extends Annotation>)ContainerConstant.Exclude.class));
        Field[] fields = ReflectUtils.getFields(this.constantClass);
        LinkedHashMap data = new LinkedHashMap();
        Stream.of(fields).filter(fieldFilter).forEach(field -> {
            Object value = ReflectUtils.getFieldValue(null, field);
            ContainerConstant.Name name = this.annotationFinder.getAnnotation((AnnotatedElement)field, ContainerConstant.Name.class);
            String key = Objects.isNull(name) ? field.getName() : name.value();
            data.put(key, value);
        });
        String actualNamespace = StringUtils.emptyToDefault(this.namespace, this.constantClass.getSimpleName());
        return ImmutableMapContainer.forMap(actualNamespace, isReverse ? CollectionUtils.reverse(data) : data);
    }
}

