/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.container;

import cn.crane4j.core.container.Container;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ContainerDefinition {
    public static SimpleContainerDefinition create(String namespace, @Nullable String providerName, @Nullable Supplier<Container<Object>> containerFactory) {
        return new SimpleContainerDefinition(namespace, providerName, containerFactory);
    }

    public String getNamespace();

    public String getProviderName();

    public Supplier<Container<Object>> getContainerFactory();

    public void setContainerFactory(Supplier<Container<Object>> var1);

    default public <K> Container<K> createContainer() {
        return this.getContainerFactory().get();
    }

    public static class SimpleContainerDefinition
    implements ContainerDefinition {
        private final String namespace;
        private final @Nullable String providerName;
        private @Nullable Supplier<Container<Object>> containerFactory;

        SimpleContainerDefinition(String namespace, @Nullable String providerName, @Nullable Supplier<Container<Object>> containerFactory) {
            this.namespace = namespace;
            this.providerName = providerName;
            this.containerFactory = containerFactory;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public @Nullable String getProviderName() {
            return this.providerName;
        }

        @Override
        public @Nullable Supplier<Container<Object>> getContainerFactory() {
            return this.containerFactory;
        }

        @Override
        public void setContainerFactory(@Nullable Supplier<Container<Object>> containerFactory) {
            this.containerFactory = containerFactory;
        }
    }
}

