/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.container;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerDefinition;
import cn.crane4j.core.container.ContainerProvider;
import cn.crane4j.core.container.lifecycle.ContainerLifecycleProcessor;
import cn.crane4j.core.util.StringUtils;
import java.util.Collection;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ContainerManager
extends ContainerProvider {
    public static final String PROVIDER_NAME_PREFIX = "&&";

    public static String canonicalNamespace(String namespace, @Nullable String providerName) {
        return StringUtils.isEmpty(providerName) ? namespace : providerName + PROVIDER_NAME_PREFIX + namespace;
    }

    public void clear();

    public void registerContainerLifecycleProcessor(ContainerLifecycleProcessor var1);

    public Collection<ContainerLifecycleProcessor> getContainerLifecycleProcessors();

    public void registerContainerProvider(String var1, ContainerProvider var2);

    public <T extends ContainerProvider> @Nullable T getContainerProvider(String var1);

    public @Nullable Object registerContainer(ContainerDefinition var1);

    default public @Nullable Object registerContainer(String namespace, Supplier<Container<Object>> factory) {
        ContainerDefinition.SimpleContainerDefinition definition = new ContainerDefinition.SimpleContainerDefinition(namespace, null, factory);
        return this.registerContainer(definition);
    }

    default public Object registerContainer(Container<?> container) {
        return this.registerContainer(container.getNamespace(), () -> container);
    }

    @Override
    public <K> @Nullable Container<K> getContainer(String var1);

    default public <K> @Nullable Container<K> getContainer(String providerName, String namespace) {
        return this.getContainer(ContainerManager.canonicalNamespace(namespace, providerName));
    }
}

