/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.container;

import cn.crane4j.core.container.ConstantContainerBuilder;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.EnumContainerBuilder;
import cn.crane4j.core.container.ImmutableMapContainer;
import cn.crane4j.core.container.LambdaContainer;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.DataProvider;
import cn.crane4j.core.support.reflect.PropertyOperator;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

public class Containers {
    public static <K> Container<K> empty() {
        return Container.empty();
    }

    public static <K> ImmutableMapContainer<K> forMap(String namespace, Map<K, ?> data) {
        return ImmutableMapContainer.forMap(namespace, data);
    }

    public static <K> ImmutableMapContainer<K> forEmptyData(String namespace) {
        return ImmutableMapContainer.forMap(namespace, Collections.emptyMap());
    }

    public static <K> LambdaContainer<K> forLambda(String namespace, DataProvider<K, ?> lambda) {
        return LambdaContainer.forLambda(namespace, lambda);
    }

    public static Container<Object> forConstantClass(Class<?> constantClass, AnnotationFinder annotationFinder) {
        return ConstantContainerBuilder.of(constantClass).annotationFinder(annotationFinder).build();
    }

    public static <K, T extends Enum<?>> Container<K> forEnum(String namespace, Class<T> enumType, Function<? super T, K> keyGetter) {
        return EnumContainerBuilder.of(enumType).enableContainerEnumAnnotation(false).namespace(namespace).keyGetter(keyGetter).build();
    }

    public static <K> Container<K> forEnum(Class<? extends Enum<?>> enumType, AnnotationFinder annotationFinder, PropertyOperator propertyOperator) {
        return EnumContainerBuilder.of(enumType).annotationFinder(annotationFinder).propertyOperator(propertyOperator).build();
    }

    private Containers() {
    }
}

