/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.container;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.support.DataProvider;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class LambdaContainer<K>
implements Container<K> {
    private final String namespace;
    private final DataProvider<K, ?> dataSource;

    public static <K> LambdaContainer<K> forLambda(String namespace, DataProvider<K, ?> lambda) {
        Objects.requireNonNull(namespace, "container namespace must not null");
        Objects.requireNonNull(lambda, "lambda must not null");
        return new LambdaContainer<K>(namespace, lambda);
    }

    @Override
    public Map<K, ?> get(Collection<K> keys) {
        return (Map)this.dataSource.apply(keys);
    }

    private LambdaContainer(String namespace, DataProvider<K, ?> dataSource) {
        this.namespace = namespace;
        this.dataSource = dataSource;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }
}

