/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.container.lifecycle;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerDefinition;
import cn.crane4j.core.container.lifecycle.ContainerLifecycleProcessor;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ContainerRegisterLogger
implements ContainerLifecycleProcessor {
    private final BiConsumer<String, Object[]> logConsumer;

    @Override
    public ContainerDefinition whenRegistered(@Nullable Object old, ContainerDefinition newDefinition) {
        if (Objects.isNull(old)) {
            this.logConsumer.accept("register container definition [{}]", new Object[]{newDefinition.getNamespace()});
        } else {
            this.logConsumer.accept("replace container definition [{}]", new Object[]{newDefinition.getNamespace()});
        }
        return newDefinition;
    }

    @Override
    public @Nullable Container<Object> whenCreated(ContainerDefinition definition, Container<Object> container) {
        this.logConsumer.accept("create container [{}] from definition [{}]", new Object[]{container.hashCode(), definition.getNamespace()});
        return container;
    }

    @Override
    public void whenDestroyed(Object target) {
        if (target instanceof ContainerDefinition) {
            String namespace = ((ContainerDefinition)target).getNamespace();
            this.logConsumer.accept("destroy container definition [{}] of [{}]", new Object[]{namespace});
            return;
        }
        Container container = (Container)target;
        this.logConsumer.accept("destroy container comparator [{}]", new Object[]{container.hashCode(), container.getNamespace()});
    }

    public ContainerRegisterLogger(BiConsumer<String, Object[]> logConsumer) {
        this.logConsumer = logConsumer;
    }
}

