/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.exception.OperationExecuteException;
import cn.crane4j.core.executor.AbstractBeanOperationExecutor;
import cn.crane4j.core.executor.AssembleExecution;
import cn.crane4j.core.executor.BeanOperationExecutor;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisorderedBeanOperationExecutor
extends AbstractBeanOperationExecutor {
    private static final Logger log = LoggerFactory.getLogger(DisorderedBeanOperationExecutor.class);

    public DisorderedBeanOperationExecutor(ContainerManager containerManager) {
        super(containerManager);
    }

    @Override
    protected void executeOperations(List<AssembleExecution> executions, BeanOperationExecutor.Options options) throws OperationExecuteException {
        try {
            executions.stream().collect(Collectors.groupingBy(AssembleExecution::getContainer)).forEach(this::doExecuteOperations);
        }
        catch (Exception e) {
            throw new OperationExecuteException(e);
        }
    }

    private void doExecuteOperations(Container<?> container, List<AssembleExecution> executions) {
        executions.stream().collect(Collectors.groupingBy(AssembleExecution::getHandler)).forEach((handler, es) -> DisorderedBeanOperationExecutor.tryExecute(() -> handler.process(container, (Collection<AssembleExecution>)es)));
    }
}

