/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor;

import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.exception.OperationExecuteException;
import cn.crane4j.core.executor.AbstractBeanOperationExecutor;
import cn.crane4j.core.executor.AssembleExecution;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.parser.operation.AssembleOperation;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class OrderedBeanOperationExecutor
extends AbstractBeanOperationExecutor {
    private final Comparator<AssembleOperation> comparator;

    public OrderedBeanOperationExecutor(ContainerManager containerManager, Comparator<AssembleOperation> comparator) {
        super(containerManager);
        this.comparator = comparator;
    }

    @Override
    protected void executeOperations(List<AssembleExecution> executions, BeanOperationExecutor.Options options) throws OperationExecuteException {
        try {
            executions.stream().sorted(Comparator.comparing(AssembleExecution::getOperation, this.comparator)).forEach(e -> OrderedBeanOperationExecutor.tryExecute(() -> e.getHandler().process(e.getContainer(), Collections.singletonList(e))));
        }
        catch (Exception e2) {
            throw new OperationExecuteException(e2);
        }
    }
}

