/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor.handler;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.executor.AssembleExecution;
import cn.crane4j.core.executor.handler.AbstractAssembleOperationHandler;
import cn.crane4j.core.executor.handler.OneToManyAssembleOperationHandler;
import cn.crane4j.core.support.reflect.PropertyOperator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ManyToManyAssembleOperationHandler
extends OneToManyAssembleOperationHandler {
    private @NonNull Function<Object, Collection<Object>> keySplitter;

    public ManyToManyAssembleOperationHandler(PropertyOperator propertyOperator, Function<Object, Collection<Object>> keySplitter) {
        super(propertyOperator);
        this.keySplitter = keySplitter;
    }

    public ManyToManyAssembleOperationHandler(PropertyOperator propertyOperator) {
        this(propertyOperator, new DefaultSplitter(","));
    }

    @Override
    protected AbstractAssembleOperationHandler.Target createTarget(AssembleExecution execution, Object origin, Object keyValue) {
        return new AbstractAssembleOperationHandler.Target(execution, origin, this.keySplitter.apply(keyValue));
    }

    @Override
    protected Map<Object, Object> getSourcesFromContainer(Container<?> container, Collection<AbstractAssembleOperationHandler.Target> targets) {
        Set keys = targets.stream().map(AbstractAssembleOperationHandler.Target::getKey).map(k -> (Collection)k).flatMap(Collection::stream).collect(Collectors.toSet());
        return container.get(keys);
    }

    @Override
    protected Object getTheAssociatedSource(AbstractAssembleOperationHandler.Target target, Map<Object, Object> sources) {
        return ((Collection)target.getKey()).stream().map(sources::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void setKeySplitter(@NonNull Function<Object, Collection<Object>> keySplitter) {
        if (keySplitter == null) {
            throw new NullPointerException("keySplitter is marked non-null but is null");
        }
        this.keySplitter = keySplitter;
    }

    public static class DefaultSplitter
    implements Function<Object, Collection<Object>> {
        private final String strSeparator;

        @Override
        public Collection<Object> apply(Object keys) {
            if (Objects.isNull(keys)) {
                return Collections.emptyList();
            }
            if (keys instanceof String) {
                String str = (String)keys;
                return Arrays.stream(str.split(this.strSeparator)).map(String::trim).collect(Collectors.toSet());
            }
            if (keys instanceof Collection) {
                return (Collection)keys;
            }
            if (keys.getClass().isArray()) {
                return Arrays.asList((Object[])keys);
            }
            return Collections.emptyList();
        }

        public DefaultSplitter(String strSeparator) {
            this.strSeparator = strSeparator;
        }
    }
}

