/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.parser;

import cn.crane4j.core.exception.OperationParseException;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.SimpleBeanOperations;
import cn.crane4j.core.parser.handler.OperationAnnotationHandler;
import cn.crane4j.core.support.Crane4jGlobalSorter;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.ReflectUtils;
import cn.crane4j.core.util.TimerUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeHierarchyBeanOperationParser
implements BeanOperationParser {
    private static final Logger log = LoggerFactory.getLogger(TypeHierarchyBeanOperationParser.class);
    protected final Map<AnnotatedElement, BeanOperations> currentlyInParsing = new LinkedHashMap<AnnotatedElement, BeanOperations>(8);
    protected final Map<AnnotatedElement, BeanOperations> resolvedHierarchyElements = CollectionUtils.newWeakConcurrentMap();
    protected final Map<AnnotatedElement, BeanOperations> resolvedElements = new ConcurrentHashMap<AnnotatedElement, BeanOperations>(64);
    protected List<OperationAnnotationHandler> operationAnnotationHandlers = new ArrayList<OperationAnnotationHandler>(5);
    protected boolean enableHierarchyCache = false;

    public void addOperationAnnotationHandler(OperationAnnotationHandler handler) {
        Objects.requireNonNull(handler, "handler must not null");
        this.operationAnnotationHandlers.remove(handler);
        this.operationAnnotationHandlers.add(handler);
        this.operationAnnotationHandlers.sort(Crane4jGlobalSorter.comparator());
    }

    @Override
    @NonNull
    public BeanOperations parse(AnnotatedElement element) throws OperationParseException {
        Objects.requireNonNull(element, "the element to be parsed cannot be null");
        try {
            return this.parseIfNecessary(element);
        }
        catch (Exception e) {
            throw new OperationParseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanOperations parseIfNecessary(AnnotatedElement element) {
        BeanOperations result = this.resolvedElements.get(element);
        if (Objects.isNull(result)) {
            TypeHierarchyBeanOperationParser typeHierarchyBeanOperationParser = this;
            synchronized (typeHierarchyBeanOperationParser) {
                result = this.resolvedElements.get(element);
                if (Objects.isNull(result)) {
                    result = this.currentlyInParsing.get(element);
                    if (Objects.isNull(result)) {
                        result = TimerUtil.getExecutionTime(log.isDebugEnabled(), time -> log.debug("parsing of element [{}] completed in {} ms", (Object)element, (Object)time), () -> this.doParse(element));
                    } else {
                        log.debug("target [{}] is in parsing, get early cache", (Object)element);
                    }
                }
            }
        }
        return result;
    }

    private BeanOperations doParse(AnnotatedElement element) {
        BeanOperations result = this.createBeanOperations(element);
        result.setActive(false);
        this.currentlyInParsing.put(element, result);
        this.doParse(result);
        this.resolvedElements.put(element, this.currentlyInParsing.remove(element));
        result.setActive(true);
        return result;
    }

    private void doParse(BeanOperations root) {
        AnnotatedElement source = root.getSource();
        log.debug("parse operations from element [{}]", (Object)source);
        Collection<BeanOperations> resolvedOperations = source instanceof Class ? this.doParseForType((Class)source) : (source instanceof Method ? this.doParseForMethod((Method)source) : this.doParseForElement(source));
        resolvedOperations.forEach(op -> {
            op.getAssembleOperations().forEach(root::addAssembleOperations);
            op.getDisassembleOperations().forEach(root::addDisassembleOperations);
        });
    }

    protected BeanOperations createBeanOperations(AnnotatedElement element) {
        return new SimpleBeanOperations(element);
    }

    protected Collection<BeanOperations> doParseForElement(AnnotatedElement element) {
        BeanOperations current = this.resolveToOperations(element);
        return Collections.singletonList(current);
    }

    protected Collection<BeanOperations> doParseForType(Class<?> beanType) {
        ArrayList<BeanOperations> results = new ArrayList<BeanOperations>();
        ReflectUtils.traverseTypeHierarchy(beanType, type -> {
            BeanOperations current = this.resolveToOperations((AnnotatedElement)type);
            results.add(current);
        });
        return results;
    }

    protected Collection<BeanOperations> doParseForMethod(Method method) {
        String methodName = method.getName();
        Class[] parameterTypes = method.getParameterTypes();
        ArrayList<BeanOperations> results = new ArrayList<BeanOperations>();
        ReflectUtils.traverseTypeHierarchy(method.getDeclaringClass(), type -> {
            Method targetMethod = ReflectUtils.getDeclaredMethod(type, methodName, parameterTypes);
            if (Objects.nonNull(targetMethod)) {
                BeanOperations current = this.resolveToOperations(targetMethod);
                results.add(current);
            }
        });
        return results;
    }

    protected final BeanOperations resolveToOperations(AnnotatedElement source) {
        if (this.enableHierarchyCache) {
            return CollectionUtils.computeIfAbsent(this.resolvedHierarchyElements, source, this::doResolveToOperations);
        }
        return this.doResolveToOperations(source);
    }

    private BeanOperations doResolveToOperations(AnnotatedElement source) {
        if (ReflectUtils.isJdkElement(source)) {
            return BeanOperations.empty();
        }
        BeanOperations operations = this.createBeanOperations(source);
        this.operationAnnotationHandlers.forEach(resolver -> resolver.resolve(this, operations));
        return operations;
    }

    public void setEnableHierarchyCache(boolean enableHierarchyCache) {
        this.enableHierarchyCache = enableHierarchyCache;
    }
}

