/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support;

import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.Grouped;
import cn.crane4j.core.support.TypeResolver;
import cn.crane4j.core.util.CollectionUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

public class OperateTemplate {
    private final BeanOperationParser defaultParser;
    private final BeanOperationExecutor defaultExecutor;
    private final TypeResolver typeResolver;

    public void executeIfMatchAnyGroups(Object target, String ... groups) {
        this.execute(target, Grouped.anyMatch(groups));
    }

    public void executeIfNoneMatchAnyGroups(Object target, String ... groups) {
        this.execute(target, Grouped.anyMatch(groups).negate());
    }

    public void executeIfMatchAllGroups(Object target, String ... groups) {
        this.execute(target, Grouped.allMatch(groups));
    }

    public void execute(Object target) {
        this.execute(CollectionUtils.adaptObjectToCollection(target), this.resolveType(target), this.defaultParser, this.defaultExecutor, Grouped.alwaysMatch());
    }

    public void execute(Object target, BeanOperations beanOperations) {
        if (Objects.nonNull(target) && Objects.nonNull(beanOperations)) {
            this.defaultExecutor.execute(CollectionUtils.adaptObjectToCollection(target), beanOperations, Grouped.alwaysMatch());
        }
    }

    public void execute(Object target, BeanOperations beanOperations, Predicate<? super KeyTriggerOperation> filter) {
        if (Objects.nonNull(target) && Objects.nonNull(beanOperations)) {
            this.defaultExecutor.execute(CollectionUtils.adaptObjectToCollection(target), beanOperations, filter);
        }
    }

    public void execute(Object target, Predicate<? super KeyTriggerOperation> filter) {
        this.execute(CollectionUtils.adaptObjectToCollection(target), this.resolveType(target), this.defaultParser, this.defaultExecutor, filter);
    }

    public void execute(Object target, BeanOperationExecutor executor, Predicate<? super KeyTriggerOperation> filter) {
        this.execute(CollectionUtils.adaptObjectToCollection(target), this.resolveType(target), this.defaultParser, executor, filter);
    }

    public void execute(Collection<?> targets, Class<?> targetType) {
        this.execute(targets, targetType, this.defaultParser, this.defaultExecutor, Grouped.alwaysMatch());
    }

    public void execute(Collection<?> targets, Class<?> targetType, BeanOperationParser parser, BeanOperationExecutor executor, Predicate<? super KeyTriggerOperation> filter) {
        if (CollectionUtils.isEmpty(targets)) {
            return;
        }
        Objects.requireNonNull(targetType, "targetType must not null");
        Objects.requireNonNull(parser, "parser must not null");
        Objects.requireNonNull(executor, "executor must not null");
        BeanOperations beanOperations = parser.parse(targetType);
        executor.execute(targets, beanOperations, filter);
    }

    private <T> Class<T> resolveType(Object target) {
        Class<?> type = this.typeResolver.resolve(target);
        return Objects.isNull(type) ? null : type;
    }

    public OperateTemplate(BeanOperationParser defaultParser, BeanOperationExecutor defaultExecutor, TypeResolver typeResolver) {
        this.defaultParser = defaultParser;
        this.defaultExecutor = defaultExecutor;
        this.typeResolver = typeResolver;
    }
}

