/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support;

import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.container.ContainerProvider;
import cn.crane4j.core.container.DefaultContainerManager;
import cn.crane4j.core.container.lifecycle.ContainerRegisterLogger;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.executor.DisorderedBeanOperationExecutor;
import cn.crane4j.core.executor.OrderedBeanOperationExecutor;
import cn.crane4j.core.executor.handler.AssembleOperationHandler;
import cn.crane4j.core.executor.handler.DisassembleOperationHandler;
import cn.crane4j.core.executor.handler.ManyToManyAssembleOperationHandler;
import cn.crane4j.core.executor.handler.OneToManyAssembleOperationHandler;
import cn.crane4j.core.executor.handler.OneToOneAssembleOperationHandler;
import cn.crane4j.core.executor.handler.ReflectiveDisassembleOperationHandler;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.TypeHierarchyBeanOperationParser;
import cn.crane4j.core.parser.handler.AssembleAnnotationHandler;
import cn.crane4j.core.parser.handler.AssembleEnumAnnotationHandler;
import cn.crane4j.core.parser.handler.DisassembleAnnotationHandler;
import cn.crane4j.core.parser.handler.strategy.OverwriteMappingStrategy;
import cn.crane4j.core.parser.handler.strategy.OverwriteNotNullMappingStrategy;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategy;
import cn.crane4j.core.parser.handler.strategy.ReferenceMappingStrategy;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Crane4jGlobalSorter;
import cn.crane4j.core.support.SimpleAnnotationFinder;
import cn.crane4j.core.support.SimpleTypeResolver;
import cn.crane4j.core.support.TypeResolver;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.converter.HutoolConverterManager;
import cn.crane4j.core.support.reflect.ChainAccessiblePropertyOperator;
import cn.crane4j.core.support.reflect.MapAccessiblePropertyOperator;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.support.reflect.ReflectivePropertyOperator;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.ConfigurationUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCrane4jGlobalConfiguration
extends DefaultContainerManager
implements Crane4jGlobalConfiguration {
    private TypeResolver typeResolver;
    private PropertyOperator propertyOperator;
    private ConverterManager converterManager;
    private final Map<String, BeanOperationParser> beanOperationParserMap = new HashMap<String, BeanOperationParser>(16);
    private final Map<String, AssembleOperationHandler> assembleOperationHandlerMap = new HashMap<String, AssembleOperationHandler>(4);
    private final Map<String, DisassembleOperationHandler> disassembleOperationHandlerMap = new HashMap<String, DisassembleOperationHandler>(4);
    private final Map<String, BeanOperationExecutor> beanOperationExecutorMap = new HashMap<String, BeanOperationExecutor>(4);

    public static SimpleCrane4jGlobalConfiguration create() {
        AnnotationFinder af = SimpleAnnotationFinder.INSTANCE;
        HutoolConverterManager cm = new HutoolConverterManager();
        ReflectivePropertyOperator operator = new ReflectivePropertyOperator(cm);
        return SimpleCrane4jGlobalConfiguration.create(af, cm, operator);
    }

    public static SimpleCrane4jGlobalConfiguration create(AnnotationFinder annotationFinder, ConverterManager converter, PropertyOperator operator) {
        SimpleCrane4jGlobalConfiguration configuration = new SimpleCrane4jGlobalConfiguration();
        configuration.setConverterManager(converter);
        operator = new MapAccessiblePropertyOperator(operator);
        operator = new ChainAccessiblePropertyOperator(operator);
        configuration.setPropertyOperator(operator);
        configuration.setTypeResolver(new SimpleTypeResolver());
        Logger logger = LoggerFactory.getLogger(ContainerRegisterLogger.class);
        configuration.registerContainerLifecycleProcessor(new ContainerRegisterLogger((arg_0, arg_1) -> ((Logger)logger).info(arg_0, arg_1)));
        List<PropertyMappingStrategy> propertyMappingStrategies = Arrays.asList(OverwriteMappingStrategy.INSTANCE, OverwriteNotNullMappingStrategy.INSTANCE, new ReferenceMappingStrategy(operator));
        TypeHierarchyBeanOperationParser beanOperationParser = new TypeHierarchyBeanOperationParser();
        AssembleAnnotationHandler assembleAnnotationHandler = new AssembleAnnotationHandler(annotationFinder, configuration);
        beanOperationParser.addOperationAnnotationHandler(assembleAnnotationHandler);
        propertyMappingStrategies.forEach(assembleAnnotationHandler::addPropertyMappingStrategy);
        AssembleEnumAnnotationHandler assembleEnumAnnotationHandler = new AssembleEnumAnnotationHandler(annotationFinder, configuration, operator, (ContainerManager)configuration);
        beanOperationParser.addOperationAnnotationHandler(assembleEnumAnnotationHandler);
        propertyMappingStrategies.forEach(assembleEnumAnnotationHandler::addPropertyMappingStrategy);
        DisassembleAnnotationHandler disassembleAnnotationHandler = new DisassembleAnnotationHandler(annotationFinder, configuration);
        beanOperationParser.addOperationAnnotationHandler(disassembleAnnotationHandler);
        configuration.getBeanOperationParserMap().put(BeanOperationParser.class.getSimpleName(), beanOperationParser);
        configuration.getBeanOperationParserMap().put(beanOperationParser.getClass().getSimpleName(), beanOperationParser);
        DisorderedBeanOperationExecutor disorderedBeanOperationExecutor = new DisorderedBeanOperationExecutor(configuration);
        configuration.getBeanOperationExecutorMap().put(BeanOperationExecutor.class.getSimpleName(), disorderedBeanOperationExecutor);
        configuration.getBeanOperationExecutorMap().put(disorderedBeanOperationExecutor.getClass().getSimpleName(), disorderedBeanOperationExecutor);
        OrderedBeanOperationExecutor orderedBeanOperationExecutor = new OrderedBeanOperationExecutor(configuration, Crane4jGlobalSorter.comparator());
        configuration.getBeanOperationExecutorMap().put(orderedBeanOperationExecutor.getClass().getSimpleName(), orderedBeanOperationExecutor);
        OneToOneAssembleOperationHandler oneToOneReflexAssembleOperationHandler = new OneToOneAssembleOperationHandler(operator);
        configuration.getAssembleOperationHandlerMap().put(AssembleOperationHandler.class.getSimpleName(), oneToOneReflexAssembleOperationHandler);
        configuration.getAssembleOperationHandlerMap().put(oneToOneReflexAssembleOperationHandler.getClass().getSimpleName(), oneToOneReflexAssembleOperationHandler);
        OneToManyAssembleOperationHandler oneToManyReflexAssembleOperationHandler = new OneToManyAssembleOperationHandler(operator);
        configuration.getAssembleOperationHandlerMap().put(oneToManyReflexAssembleOperationHandler.getClass().getSimpleName(), oneToManyReflexAssembleOperationHandler);
        ManyToManyAssembleOperationHandler manyToManyReflexAssembleOperationHandler = new ManyToManyAssembleOperationHandler(operator);
        configuration.getAssembleOperationHandlerMap().put(manyToManyReflexAssembleOperationHandler.getClass().getSimpleName(), manyToManyReflexAssembleOperationHandler);
        ReflectiveDisassembleOperationHandler reflectiveDisassembleOperationHandler = new ReflectiveDisassembleOperationHandler(operator);
        configuration.getDisassembleOperationHandlerMap().put(DisassembleOperationHandler.class.getSimpleName(), reflectiveDisassembleOperationHandler);
        configuration.getDisassembleOperationHandlerMap().put(reflectiveDisassembleOperationHandler.getClass().getSimpleName(), reflectiveDisassembleOperationHandler);
        configuration.registerContainerProvider(configuration.getClass().getSimpleName(), configuration);
        configuration.registerContainerProvider(ContainerProvider.class.getSimpleName(), configuration);
        return configuration;
    }

    @Override
    public @NonNull BeanOperationExecutor getBeanOperationExecutor(@Nullable String executorName, Class<?> executorType) {
        BeanOperationExecutor executor = ConfigurationUtil.getComponentFromConfiguration(BeanOperationExecutor.class, executorType, executorName, (t, n) -> {
            BeanOperationExecutor r = this.beanOperationExecutorMap.get(n);
            return t.isAssignableFrom(r.getClass()) ? r : null;
        }, t -> this.beanOperationExecutorMap.get(t.getSimpleName()));
        Asserts.isNotNull(executor, "cannot find executor [{}]({})", executorName, executorType);
        return executor;
    }

    @Override
    public @NonNull BeanOperationParser getBeanOperationsParser(@Nullable String parserName, Class<?> parserType) {
        BeanOperationParser parser = ConfigurationUtil.getComponentFromConfiguration(BeanOperationParser.class, parserType, parserName, (t, n) -> {
            BeanOperationParser r = this.beanOperationParserMap.get(n);
            return t.isAssignableFrom(r.getClass()) ? r : null;
        }, t -> this.beanOperationParserMap.get(t.getSimpleName()));
        Asserts.isNotNull(parser, "cannot find parser [{}]({})", parserName, parserType);
        return parser;
    }

    @Override
    public @NonNull AssembleOperationHandler getAssembleOperationHandler(@Nullable String handlerName, Class<?> handlerType) {
        AssembleOperationHandler parser = ConfigurationUtil.getComponentFromConfiguration(AssembleOperationHandler.class, handlerType, handlerName, (t, n) -> {
            AssembleOperationHandler r = this.assembleOperationHandlerMap.get(n);
            return t.isAssignableFrom(r.getClass()) ? r : null;
        }, t -> this.assembleOperationHandlerMap.get(t.getSimpleName()));
        Asserts.isNotNull(parser, "cannot find assemble handler [{}]({})", handlerName, handlerType);
        return parser;
    }

    @Override
    public @NonNull DisassembleOperationHandler getDisassembleOperationHandler(@Nullable String handlerName, Class<?> handlerType) {
        DisassembleOperationHandler parser = ConfigurationUtil.getComponentFromConfiguration(DisassembleOperationHandler.class, handlerType, handlerName, (t, n) -> {
            DisassembleOperationHandler r = this.disassembleOperationHandlerMap.get(n);
            return t.isAssignableFrom(r.getClass()) ? r : null;
        }, t -> this.disassembleOperationHandlerMap.get(t.getSimpleName()));
        Asserts.isNotNull(parser, "cannot find disassemble handler [{}]({})", handlerName, handlerType);
        return parser;
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public PropertyOperator getPropertyOperator() {
        return this.propertyOperator;
    }

    @Override
    public ConverterManager getConverterManager() {
        return this.converterManager;
    }

    public Map<String, BeanOperationParser> getBeanOperationParserMap() {
        return this.beanOperationParserMap;
    }

    public Map<String, AssembleOperationHandler> getAssembleOperationHandlerMap() {
        return this.assembleOperationHandlerMap;
    }

    public Map<String, DisassembleOperationHandler> getDisassembleOperationHandlerMap() {
        return this.disassembleOperationHandlerMap;
    }

    public Map<String, BeanOperationExecutor> getBeanOperationExecutorMap() {
        return this.beanOperationExecutorMap;
    }

    public void setTypeResolver(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public void setPropertyOperator(PropertyOperator propertyOperator) {
        this.propertyOperator = propertyOperator;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }
}

