/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.aop;

import cn.crane4j.annotation.ArgAutoOperate;
import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.ParameterNameFinder;
import cn.crane4j.core.support.aop.AutoOperateAnnotatedElement;
import cn.crane4j.core.support.aop.AutoOperateAnnotatedElementResolver;
import cn.crane4j.core.support.expression.MethodBaseExpressionExecuteDelegate;
import cn.crane4j.core.util.ArrayUtils;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.ReflectUtils;
import cn.crane4j.core.util.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodArgumentAutoOperateSupport {
    private static final Logger log = LoggerFactory.getLogger(MethodArgumentAutoOperateSupport.class);
    protected static final AutoOperateAnnotatedElement[] EMPTY_ELEMENTS = new AutoOperateAnnotatedElement[0];
    protected final AutoOperateAnnotatedElementResolver elementResolver;
    protected final Map<String, AutoOperateAnnotatedElement[]> methodParameterCaches = CollectionUtils.newWeakConcurrentMap();
    protected final ParameterNameFinder parameterNameFinder;
    protected final AnnotationFinder annotationFinder;
    protected final MethodBaseExpressionExecuteDelegate expressionExecuteDelegate;

    public MethodArgumentAutoOperateSupport(AutoOperateAnnotatedElementResolver elementResolver, MethodBaseExpressionExecuteDelegate expressionExecuteDelegate, ParameterNameFinder parameterNameFinder, AnnotationFinder annotationFinder) {
        this.elementResolver = elementResolver;
        this.annotationFinder = annotationFinder;
        this.parameterNameFinder = parameterNameFinder;
        this.expressionExecuteDelegate = expressionExecuteDelegate;
    }

    public final void beforeMethodInvoke(Method method, Object[] args) {
        if (ArrayUtils.isEmpty(args)) {
            return;
        }
        ArgAutoOperate methodLevelAnnotation = this.annotationFinder.findAnnotation(method, ArgAutoOperate.class);
        AutoOperateAnnotatedElement[] elements = CollectionUtils.computeIfAbsent(this.methodParameterCaches, method.getName(), name -> this.resolveParameters(methodLevelAnnotation, method));
        if (elements == EMPTY_ELEMENTS) {
            return;
        }
        log.debug("process arguments for [{}]", (Object)method.getName());
        this.processArguments(method, args, elements);
    }

    protected void processArguments(Method method, Object[] args, AutoOperateAnnotatedElement[] autoOperateAnnotatedElements) {
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            AutoOperateAnnotatedElement element = autoOperateAnnotatedElements[i];
            if (!Objects.nonNull(element) || !this.support(method, args, element.getAnnotation().condition())) continue;
            element.execute(arg);
        }
    }

    protected AutoOperateAnnotatedElement[] resolveParameters(@Nullable ArgAutoOperate argAutoOperate, Method method) {
        Map methodLevelAnnotations = Optional.ofNullable(argAutoOperate).map(ArgAutoOperate::value).map(Arrays::stream).map(s -> s.collect(Collectors.toMap(AutoOperate::value, Function.identity()))).orElseGet(Collections::emptyMap);
        Map<String, Parameter> parameterMap = ReflectUtils.resolveParameterNames(this.parameterNameFinder, method);
        AutoOperateAnnotatedElement[] results = new AutoOperateAnnotatedElement[parameterMap.size()];
        int index = 0;
        for (Map.Entry<String, Parameter> entry : parameterMap.entrySet()) {
            String paramName = entry.getKey();
            Parameter param = entry.getValue();
            AutoOperate annotation = Optional.ofNullable(this.annotationFinder.getAnnotation(param, AutoOperate.class)).orElse((AutoOperate)methodLevelAnnotations.get(paramName));
            results[index++] = Objects.isNull(annotation) ? null : this.elementResolver.resolve(param, annotation);
        }
        return results;
    }

    private boolean support(Method method, Object[] args, String condition) {
        return StringUtils.isEmpty(condition) || Boolean.TRUE.equals(this.expressionExecuteDelegate.execute(condition, Boolean.class, method, args, null));
    }
}

