/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.container;

import cn.crane4j.annotation.ContainerCache;
import cn.crane4j.annotation.ContainerMethod;
import cn.crane4j.core.cache.CacheManager;
import cn.crane4j.core.container.CacheableContainer;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.container.DefaultMethodContainerFactory;
import cn.crane4j.core.support.container.MethodInvokerContainerCreator;
import cn.crane4j.core.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheableMethodContainerFactory
extends DefaultMethodContainerFactory {
    private static final Logger log = LoggerFactory.getLogger(CacheableMethodContainerFactory.class);
    public static final int ORDER = 0x7FFFFFFE;
    private final CacheManager cacheManager;

    public CacheableMethodContainerFactory(MethodInvokerContainerCreator methodInvokerContainerCreator, AnnotationFinder annotationFinder, CacheManager cacheManager) {
        super(methodInvokerContainerCreator, annotationFinder);
        this.cacheManager = cacheManager;
    }

    @Override
    public int getSort() {
        return 0x7FFFFFFE;
    }

    @Override
    public boolean support(Object source, Method method, Collection<ContainerMethod> annotations) {
        ContainerCache annotation = this.annotationFinder.findAnnotation(method, ContainerCache.class);
        return Objects.nonNull(annotation) && super.support(source, method, annotations);
    }

    @Override
    public List<Container<Object>> get(Object source, Method method, Collection<ContainerMethod> annotations) {
        log.debug("create cacheable method container from [{}]", (Object)method);
        ContainerCache annotation = this.annotationFinder.findAnnotation(method, ContainerCache.class);
        Function<Container, String> cacheNameFactory = container -> StringUtils.emptyToDefault(annotation.cacheName(), container.getNamespace());
        return super.get(source, method, annotations).stream().map(container -> new CacheableContainer(container, this.cacheManager, (String)cacheNameFactory.apply((Container)container))).collect(Collectors.toList());
    }
}

