/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.container;

import cn.crane4j.annotation.MappingType;
import cn.crane4j.core.container.MethodInvokerContainer;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.converter.ParameterConvertibleMethodInvoker;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.support.reflect.ReflectiveMethodInvoker;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.StringUtils;
import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodInvokerContainerCreator {
    private static final Logger log = LoggerFactory.getLogger(MethodInvokerContainerCreator.class);
    protected final PropertyOperator propertyOperator;
    protected final ConverterManager converterManager;

    public MethodInvokerContainer createContainer(Object target, Method method, MappingType mappingType, @Nullable String namespace, Class<?> resultType, String resultKey) {
        log.debug("create method container from [{}]", (Object)method);
        MethodInvokerContainer.KeyExtractor keyExtractor = this.getKeyExtractor(mappingType, resultType, resultKey);
        MethodInvoker methodInvoker = this.getMethodInvoker(target, method);
        namespace = MethodInvokerContainerCreator.getNamespace(method, namespace);
        return this.createMethodInvokerContainer(target, mappingType, namespace, keyExtractor, methodInvoker);
    }

    public MethodInvokerContainer createContainer(Object target, MethodInvoker methodInvoker, MappingType mappingType, String namespace, Class<?> resultType, String resultKey) {
        log.debug("create method container from [{}]", (Object)methodInvoker);
        MethodInvokerContainer.KeyExtractor keyExtractor = this.getKeyExtractor(mappingType, resultType, resultKey);
        return this.createMethodInvokerContainer(target, mappingType, namespace, keyExtractor, methodInvoker);
    }

    protected @NonNull MethodInvokerContainer createMethodInvokerContainer(Object target, MappingType mappingType, String namespace, MethodInvokerContainer.KeyExtractor keyExtractor, MethodInvoker methodInvoker) {
        return new MethodInvokerContainer(namespace, methodInvoker, target, keyExtractor, mappingType);
    }

    protected @NonNull MethodInvoker getMethodInvoker(Object target, Method method) {
        ReflectiveMethodInvoker invoker = ReflectiveMethodInvoker.create(target, method, false);
        return ParameterConvertibleMethodInvoker.create(invoker, this.converterManager, method.getParameterTypes());
    }

    protected @Nullable MethodInvokerContainer.KeyExtractor getKeyExtractor(MappingType mappingType, Class<?> resultType, String resultKey) {
        MethodInvokerContainer.KeyExtractor keyExtractor = null;
        if (mappingType != MappingType.MAPPED) {
            MethodInvoker keyGetter = this.findKeyGetter(resultType, resultKey);
            keyExtractor = x$0 -> keyGetter.invoke(x$0, new Object[0]);
        }
        return keyExtractor;
    }

    protected static String getNamespace(Method method, String namespace) {
        return StringUtils.emptyToDefault(namespace, method.getName());
    }

    protected MethodInvoker findKeyGetter(Class<?> resultType, String resultKey) {
        MethodInvoker keyGetter = this.propertyOperator.findGetter(resultType, resultKey);
        Asserts.isNotNull(keyGetter, "cannot find getter method [{}] on [{}]", resultKey, resultType);
        return keyGetter;
    }

    public MethodInvokerContainerCreator(PropertyOperator propertyOperator, ConverterManager converterManager) {
        this.propertyOperator = propertyOperator;
        this.converterManager = converterManager;
    }
}

