/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.expression;

import cn.crane4j.core.support.ParameterNameFinder;
import cn.crane4j.core.support.expression.ExpressionContext;
import cn.crane4j.core.support.expression.ExpressionEvaluator;
import cn.crane4j.core.util.ArrayUtils;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MethodBaseExpressionExecuteDelegate {
    public static final String RESULT = "result";
    protected final ParameterNameFinder parameterNameDiscoverer;
    protected final ExpressionEvaluator expressionEvaluator;
    protected final Function<Method, ExpressionContext> contextFactory;

    public <T> @Nullable T execute(String expression, Class<T> resultType, MethodExecution execution) {
        ExpressionContext context = this.resolveContext(execution);
        return this.expressionEvaluator.execute(expression, resultType, context);
    }

    public <T> @Nullable T execute(String expression, Class<T> resultType, Method method, Object[] args, Object result) {
        return this.execute(expression, resultType, new MethodExecution(args, method, result));
    }

    protected ExpressionContext resolveContext(MethodExecution methodExecution) {
        ExpressionContext context = this.contextFactory.apply(methodExecution.getMethod());
        this.registerParams(methodExecution, context);
        context.registerVariable(RESULT, methodExecution.getResult());
        return context;
    }

    protected void registerParams(MethodExecution methodExecution, ExpressionContext context) {
        String[] paramNames = this.parameterNameDiscoverer.getParameterNames(methodExecution.getMethod());
        Object[] args = methodExecution.getArgs();
        Map<String, Object> paramsMap = this.resolvedParams(paramNames, args);
        paramsMap.forEach(context::registerVariable);
        for (int i = 0; i < args.length; ++i) {
            context.registerVariable("a" + i, args[i]);
        }
    }

    protected Map<String, Object> resolvedParams(String[] paramNames, Object[] args) {
        if (ArrayUtils.isEmpty(paramNames)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>(paramNames.length);
        int argCount = args.length;
        for (int i = 0; i < paramNames.length; ++i) {
            String name = paramNames[i];
            Object arg = i < argCount ? args[i] : null;
            results.put(name, arg);
        }
        return results;
    }

    public MethodBaseExpressionExecuteDelegate(ParameterNameFinder parameterNameDiscoverer, ExpressionEvaluator expressionEvaluator, Function<Method, ExpressionContext> contextFactory) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
        this.expressionEvaluator = expressionEvaluator;
        this.contextFactory = contextFactory;
    }

    public static class MethodExecution {
        private final Object[] args;
        private final Method method;
        private final Object result;

        public Object[] getArgs() {
            return this.args;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getResult() {
            return this.result;
        }

        public MethodExecution(Object[] args, Method method, Object result) {
            this.args = args;
            this.method = method;
            this.result = result;
        }
    }
}

