/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.operator;

import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.converter.ParameterConvertibleMethodInvoker;
import cn.crane4j.core.support.operator.OperatorProxyMethodFactory;
import cn.crane4j.core.util.CollectionUtils;
import java.lang.reflect.Method;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DefaultOperatorProxyMethodFactory
implements OperatorProxyMethodFactory {
    public static final int ORDER = Integer.MAX_VALUE;
    private final ConverterManager converterManager;

    @Override
    public int getSort() {
        return Integer.MAX_VALUE;
    }

    @Override
    public @Nullable MethodInvoker get(BeanOperations beanOperations, Method method, BeanOperationExecutor beanOperationExecutor) {
        ProxyMethod invoker = new ProxyMethod(beanOperations, beanOperationExecutor);
        return ParameterConvertibleMethodInvoker.create(invoker, this.converterManager, method.getParameterTypes());
    }

    public DefaultOperatorProxyMethodFactory(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    private static class ProxyMethod
    implements MethodInvoker {
        private final BeanOperations operations;
        private final BeanOperationExecutor beanOperationExecutor;

        @Override
        public Object invoke(Object target, Object ... args) {
            Object arg = args[0];
            if (Objects.nonNull(arg)) {
                this.beanOperationExecutor.execute(CollectionUtils.adaptObjectToCollection(arg), this.operations);
            }
            return arg;
        }

        public ProxyMethod(BeanOperations operations, BeanOperationExecutor beanOperationExecutor) {
            this.operations = operations;
            this.beanOperationExecutor = beanOperationExecutor;
        }
    }
}

