/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.operator;

import cn.crane4j.annotation.ContainerParam;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ImmutableMapContainer;
import cn.crane4j.core.container.LambdaContainer;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.DataProvider;
import cn.crane4j.core.support.Grouped;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.ParameterNameFinder;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.converter.ParameterConvertibleMethodInvoker;
import cn.crane4j.core.support.operator.OperatorProxyMethodFactory;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.ReflectUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicContainerOperatorProxyMethodFactory
implements OperatorProxyMethodFactory {
    private static final Logger log = LoggerFactory.getLogger(DynamicContainerOperatorProxyMethodFactory.class);
    public static final int ORDER = 0x7FFFFFFE;
    private final ConverterManager converterManager;
    private final ParameterNameFinder parameterNameFinder;
    private final AnnotationFinder annotationFinder;
    private final Map<Class<?>, ContainerParameterAdaptorProvider> adaptorProviders;

    public DynamicContainerOperatorProxyMethodFactory(ConverterManager converterManager, ParameterNameFinder parameterNameFinder, AnnotationFinder annotationFinder) {
        this.converterManager = converterManager;
        this.parameterNameFinder = parameterNameFinder;
        this.annotationFinder = annotationFinder;
        this.adaptorProviders = new LinkedHashMap();
        this.initAdaptorProvider();
    }

    @Override
    public int getSort() {
        return 0x7FFFFFFE;
    }

    private void initAdaptorProvider() {
        this.adaptorProviders.put(Map.class, (n, p) -> arg -> ImmutableMapContainer.forMap(n, (Map)arg));
        this.adaptorProviders.put(Container.class, (n, p) -> arg -> (Container)arg);
        this.adaptorProviders.put(DataProvider.class, (n, p) -> arg -> LambdaContainer.forLambda(n, (DataProvider)arg));
    }

    private @Nullable Function<Object, Container<Object>> findAdaptor(String namespace, String parameterName, Parameter parameter, Method method) {
        Class<?> parameterType = parameter.getType();
        ContainerParameterAdaptorProvider provider = this.adaptorProviders.get(parameterType);
        if (Objects.nonNull(provider)) {
            return provider.getAdaptor(namespace, parameter);
        }
        Optional<ContainerParameterAdaptorProvider> optional = this.adaptorProviders.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(parameterType)).findFirst().map(Map.Entry::getValue);
        if (!optional.isPresent()) {
            log.warn("cannot find adaptor provider for type [{}] of param [{}] in method [{}]", new Object[]{parameterType, parameterName, method});
            return null;
        }
        return optional.get().getAdaptor(namespace, parameter);
    }

    public void addAdaptorProvider(Class<?> type, ContainerParameterAdaptorProvider adaptorProvider) {
        Objects.requireNonNull(adaptorProvider, "adaptorProvider name must not null");
        this.adaptorProviders.put(type, adaptorProvider);
    }

    @Override
    public @Nullable MethodInvoker get(BeanOperations beanOperations, Method method, BeanOperationExecutor beanOperationExecutor) {
        Map<String, Parameter> parameterNameMap = ReflectUtils.resolveParameterNames(this.parameterNameFinder, method);
        if (parameterNameMap.size() == 1) {
            return null;
        }
        Function<Object, Container<Object>>[] adaptors = this.resolveContainerParameterAdaptors(method, parameterNameMap);
        if (Arrays.stream(adaptors).allMatch(Objects::isNull)) {
            return null;
        }
        DynamicContainerMethodInvoker invoker = new DynamicContainerMethodInvoker(beanOperations, beanOperationExecutor, adaptors);
        return ParameterConvertibleMethodInvoker.create(invoker, this.converterManager, method.getParameterTypes());
    }

    private @NonNull Function<Object, Container<Object>>[] resolveContainerParameterAdaptors(Method method, Map<String, Parameter> parameterNameMap) {
        Function[] adaptors = new Function[parameterNameMap.size()];
        AtomicInteger index = new AtomicInteger(0);
        parameterNameMap.forEach((name, param) -> {
            int curr = index.getAndIncrement();
            if (curr == 0) {
                return;
            }
            String namespace = Optional.ofNullable(this.annotationFinder.getAnnotation((AnnotatedElement)param, ContainerParam.class)).map(ContainerParam::value).orElse((String)name);
            adaptors[curr] = this.findAdaptor(namespace, (String)name, (Parameter)param, method);
        });
        return adaptors;
    }

    @FunctionalInterface
    public static interface ContainerParameterAdaptorProvider {
        public @Nullable Function<Object, Container<Object>> getAdaptor(String var1, Parameter var2);
    }

    protected static class DynamicContainerMethodInvoker
    implements MethodInvoker {
        private final BeanOperations operations;
        private final BeanOperationExecutor beanOperationExecutor;
        private final Function<Object, Container<Object>>[] adaptors;

        @Override
        public Object invoke(Object target, Object ... args) {
            Object bean = args[0];
            Collection<?> targets = CollectionUtils.adaptObjectToCollection(bean);
            if (targets.isEmpty()) {
                return bean;
            }
            if (args.length == 1) {
                this.beanOperationExecutor.execute(targets, this.operations);
                return bean;
            }
            Map<String, Container<Object>> temporaryContainers = IntStream.rangeClosed(0, args.length - 1).filter(i -> Objects.nonNull(args[i]) && Objects.nonNull(this.adaptors[i])).mapToObj(i -> this.adaptors[i].apply(args[i])).collect(Collectors.toMap(Container::getNamespace, Function.identity()));
            this.beanOperationExecutor.execute(targets, this.operations, new BeanOperationExecutor.Options.DynamicContainerOption(Grouped.alwaysMatch(), temporaryContainers));
            return bean;
        }

        public DynamicContainerMethodInvoker(BeanOperations operations, BeanOperationExecutor beanOperationExecutor, Function<Object, Container<Object>>[] adaptors) {
            this.operations = operations;
            this.beanOperationExecutor = beanOperationExecutor;
            this.adaptors = adaptors;
        }
    }
}

