/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.operator;

import cn.crane4j.annotation.Operator;
import cn.crane4j.core.exception.Crane4jException;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Crane4jGlobalSorter;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.operator.OperatorProxyMethodFactory;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.ReflectUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorProxyFactory {
    private static final Logger log = LoggerFactory.getLogger(OperatorProxyFactory.class);
    private static final Object NULL = new Object();
    private final Crane4jGlobalConfiguration globalConfiguration;
    private final AnnotationFinder annotationFinder;
    private final List<OperatorProxyMethodFactory> proxyMethodFactories;
    private final Map<Class<?>, Object> proxyCaches = new ConcurrentHashMap(8);

    public OperatorProxyFactory(Crane4jGlobalConfiguration globalConfiguration, AnnotationFinder annotationFinder) {
        this.globalConfiguration = globalConfiguration;
        this.annotationFinder = annotationFinder;
        this.proxyMethodFactories = new ArrayList<OperatorProxyMethodFactory>();
    }

    public void addProxyMethodFactory(OperatorProxyMethodFactory proxyMethodFactory) {
        this.proxyMethodFactories.remove(proxyMethodFactory);
        this.proxyMethodFactories.add(proxyMethodFactory);
        this.proxyMethodFactories.sort(Crane4jGlobalSorter.INSTANCE);
    }

    public <T> @Nullable T get(Class<T> operatorType) {
        Asserts.isTrue(Objects.nonNull(operatorType) && operatorType.isInterface(), "the operator type [{}] must be an interface.", operatorType);
        Object proxy = CollectionUtils.computeIfAbsent(this.proxyCaches, operatorType, this::doGetProxy);
        return (T)(proxy == NULL ? null : proxy);
    }

    private Object doGetProxy(Class<?> operatorType) {
        Operator annotation = this.annotationFinder.findAnnotation(operatorType, Operator.class);
        if (Objects.isNull(annotation)) {
            return NULL;
        }
        BeanOperationExecutor executor = this.globalConfiguration.getBeanOperationExecutor(annotation.executor(), annotation.executorType());
        BeanOperationParser parser = this.globalConfiguration.getBeanOperationsParser(annotation.parser(), annotation.executorType());
        log.debug("create operator proxy for interface [{}].", operatorType);
        OperatorProxy proxy = this.createOperatorProxy(operatorType, parser, executor);
        return Proxy.newProxyInstance(operatorType.getClassLoader(), new Class[]{operatorType}, (InvocationHandler)proxy);
    }

    private <T> OperatorProxy createOperatorProxy(Class<T> operatorType, BeanOperationParser beanOperationParser, BeanOperationExecutor beanOperationExecutor) {
        HashMap<String, MethodInvoker> beanOperationsMap = new HashMap<String, MethodInvoker>(8);
        ReflectUtils.traverseTypeHierarchy(operatorType, type -> Stream.of(ReflectUtils.getDeclaredMethods(type)).filter(method -> !method.isDefault()).map(beanOperationParser::parse).forEach(operations -> {
            this.checkOperationOfMethod((BeanOperations)operations);
            Method method = (Method)operations.getSource();
            MethodInvoker invoker = this.createOperatorMethod((BeanOperations)operations, method, beanOperationExecutor);
            beanOperationsMap.put(method.getName(), invoker);
        }));
        return new OperatorProxy(beanOperationsMap);
    }

    private void checkOperationOfMethod(BeanOperations operations) {
        Method method = (Method)operations.getSource();
        if (method.getParameterCount() < 1) {
            throw new Crane4jException("the method [{}] parameter count is less than 1.", method.getName());
        }
        if (operations.isEmpty()) {
            throw new Crane4jException("the method [{}] are no executable operations found.", method.getName());
        }
    }

    private MethodInvoker createOperatorMethod(BeanOperations beanOperations, Method method, BeanOperationExecutor beanOperationExecutor) {
        return this.proxyMethodFactories.stream().map(factory -> factory.get(beanOperations, method, beanOperationExecutor)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new Crane4jException("cannot create proxy for method [{}]", method));
    }

    private static class OperatorProxy
    implements InvocationHandler {
        private final Map<String, MethodInvoker> proxiedMethods;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            MethodInvoker invoker = this.proxiedMethods.get(method.getName());
            return Objects.isNull(invoker) ? method.invoke(proxy, args) : invoker.invoke(proxy, args);
        }

        public OperatorProxy(Map<String, MethodInvoker> proxiedMethods) {
            this.proxiedMethods = proxiedMethods;
        }
    }
}

