/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.reflect;

import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.CollectionUtils;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CacheablePropertyOperator
implements PropertyOperator {
    private static final MethodInvoker NULL = (target, args) -> null;
    private final Map<Class<?>, Map<String, MethodInvoker>> getterCaches = CollectionUtils.newWeakConcurrentMap();
    private final Map<Class<?>, Map<String, MethodInvoker>> setterCaches = CollectionUtils.newWeakConcurrentMap();
    private final PropertyOperator propertyOperator;

    @Override
    public @Nullable MethodInvoker findGetter(Class<?> targetType, String propertyName) {
        MethodInvoker invoker = this.findInvokerFromCache(this.getterCaches, targetType, propertyName, this.propertyOperator::findGetter);
        return this.resolve(invoker);
    }

    @Override
    public @Nullable MethodInvoker findSetter(Class<?> targetType, String propertyName) {
        MethodInvoker invoker = this.findInvokerFromCache(this.setterCaches, targetType, propertyName, this.propertyOperator::findSetter);
        return this.resolve(invoker);
    }

    private @Nullable MethodInvoker resolve(MethodInvoker invoker) {
        return invoker == NULL ? null : invoker;
    }

    private @NonNull MethodInvoker findInvokerFromCache(Map<Class<?>, Map<String, MethodInvoker>> caches, Class<?> targetType, String propertyName, BiFunction<Class<?>, String, MethodInvoker> invokerFactory) {
        Map invokers = CollectionUtils.computeIfAbsent(caches, targetType, t -> new ConcurrentHashMap(8));
        return CollectionUtils.computeIfAbsent(invokers, propertyName, t -> {
            MethodInvoker target = (MethodInvoker)invokerFactory.apply(targetType, propertyName);
            return Objects.isNull(target) ? NULL : target;
        });
    }

    public CacheablePropertyOperator(PropertyOperator propertyOperator) {
        this.propertyOperator = propertyOperator;
    }
}

