/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.reflect;

import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.CollectionUtils;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ChainAccessiblePropertyOperator
implements PropertyOperator {
    protected final PropertyOperator propertyOperator;
    private final Function<String, String[]> splitter;

    public ChainAccessiblePropertyOperator(PropertyOperator propertyOperator) {
        this(propertyOperator, new DefaultSplitter("."));
    }

    @Override
    public @Nullable Object readProperty(Class<?> targetType, Object target, String propertyName) {
        MethodInvoker invoker = this.findGetter(targetType, propertyName);
        return Objects.isNull(invoker) ? null : invoker.invoke(target, new Object[0]);
    }

    @Override
    public @Nullable MethodInvoker findGetter(Class<?> targetType, String propertyName) {
        String[] properties = this.splitter.apply(propertyName);
        if (properties.length <= 1) {
            return this.propertyOperator.findGetter(targetType, propertyName);
        }
        return this.chainGetter(properties);
    }

    @Override
    public void writeProperty(Class<?> targetType, Object target, String propertyName, Object value) {
        MethodInvoker invoker = this.findSetter(targetType, propertyName);
        if (Objects.nonNull(invoker)) {
            invoker.invoke(target, value);
        }
    }

    @Override
    public @Nullable MethodInvoker findSetter(Class<?> targetType, String propertyName) {
        String[] properties = this.splitter.apply(propertyName);
        if (properties.length <= 1) {
            return this.propertyOperator.findSetter(targetType, propertyName);
        }
        return this.chainSetter(properties);
    }

    private MethodInvoker chainGetter(String[] splitPropertyChain) {
        return (target, args) -> {
            for (String prop : splitPropertyChain) {
                if (Objects.isNull(target)) {
                    return null;
                }
                target = this.propertyOperator.readProperty(target.getClass(), target, prop);
            }
            return target;
        };
    }

    private MethodInvoker chainSetter(String[] splitPropertyChain) {
        return (target, args) -> {
            int deep;
            int targetDeep = splitPropertyChain.length - 1;
            for (deep = 0; deep < targetDeep; ++deep) {
                if (Objects.isNull(target)) {
                    return null;
                }
                String targetProp = splitPropertyChain[deep];
                target = this.propertyOperator.readProperty(target.getClass(), target, targetProp);
            }
            if (deep == targetDeep && Objects.nonNull(target)) {
                this.propertyOperator.writeProperty(target.getClass(), target, splitPropertyChain[targetDeep], args[0]);
            }
            return null;
        };
    }

    public ChainAccessiblePropertyOperator(PropertyOperator propertyOperator, Function<String, String[]> splitter) {
        this.propertyOperator = propertyOperator;
        this.splitter = splitter;
    }

    public static class DefaultSplitter
    implements Function<String, String[]> {
        private final String separator;
        private final Map<String, String[]> caches = CollectionUtils.newWeakConcurrentMap();

        @Override
        public String[] apply(String propertyName) {
            return CollectionUtils.computeIfAbsent(this.caches, propertyName, p -> propertyName.split("\\" + this.separator));
        }

        public DefaultSplitter(String separator) {
            this.separator = separator;
        }
    }
}

