/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.reflect;

import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.reflect.PropertyOperator;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MapAccessiblePropertyOperator
implements PropertyOperator {
    private final PropertyOperator propertyOperator;

    @Override
    public @Nullable Object readProperty(Class<?> targetType, Object target, String propertyName) {
        if (MapAccessiblePropertyOperator.isMap(targetType)) {
            return MapAccessiblePropertyOperator.castMap(target).get(propertyName);
        }
        return this.propertyOperator.readProperty(targetType, target, propertyName);
    }

    @Override
    public @Nullable MethodInvoker findGetter(Class<?> targetType, String propertyName) {
        if (MapAccessiblePropertyOperator.isMap(targetType)) {
            return (t, args) -> MapAccessiblePropertyOperator.castMap(t).get(propertyName);
        }
        return this.propertyOperator.findGetter(targetType, propertyName);
    }

    @Override
    public void writeProperty(Class<?> targetType, Object target, String propertyName, Object value) {
        if (MapAccessiblePropertyOperator.isMap(targetType)) {
            MapAccessiblePropertyOperator.castMap(target).put(propertyName, value);
            return;
        }
        this.propertyOperator.writeProperty(targetType, target, propertyName, value);
    }

    @Override
    public @Nullable MethodInvoker findSetter(Class<?> targetType, String propertyName) {
        if (MapAccessiblePropertyOperator.isMap(targetType)) {
            return (t, args) -> MapAccessiblePropertyOperator.castMap(t).put(propertyName, args[0]);
        }
        return this.propertyOperator.findSetter(targetType, propertyName);
    }

    private static Map<String, Object> castMap(Object target) {
        return (Map)target;
    }

    private static boolean isMap(Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }

    public MapAccessiblePropertyOperator(PropertyOperator propertyOperator) {
        this.propertyOperator = propertyOperator;
    }
}

