/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.reflect;

import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.util.ReflectUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ReflectiveMethodInvoker
implements MethodInvoker {
    protected final Object target;
    protected final Method method;
    protected final boolean alignArguments;

    public static ReflectiveMethodInvoker create(@Nullable Object target, Method method, boolean alignArguments) {
        if (Objects.nonNull(target) && Proxy.isProxyClass(target.getClass()) && !Proxy.isProxyClass(method.getDeclaringClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(target);
            return new ProxyMethodInvoker(handler, method, alignArguments);
        }
        return new InvocationMethodInvoker(target, method, alignArguments);
    }

    @Override
    public Object invoke(Object target, Object ... args) {
        Object[] actualArgs = this.alignArguments ? args : ReflectUtils.resolveMethodInvocationArguments(this.method, args);
        return this.invokeMethod(target, actualArgs);
    }

    protected abstract Object invokeMethod(Object var1, Object ... var2);

    public ReflectiveMethodInvoker(Object target, Method method, boolean alignArguments) {
        this.target = target;
        this.method = method;
        this.alignArguments = alignArguments;
    }

    public static class ProxyMethodInvoker
    extends ReflectiveMethodInvoker {
        public ProxyMethodInvoker(Object target, Method method, boolean invokeRow) {
            super(target, method, invokeRow);
        }

        @Override
        protected Object invokeMethod(Object target, Object ... args) {
            return ((InvocationHandler)this.target).invoke(target, this.method, args);
        }
    }

    public static class InvocationMethodInvoker
    extends ReflectiveMethodInvoker {
        public InvocationMethodInvoker(Object target, Method method, boolean invokeRow) {
            super(target, method, invokeRow);
        }

        @Override
        protected Object invokeMethod(Object target, Object ... args) {
            return ReflectUtils.invokeRaw(target, this.method, args);
        }
    }
}

