/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.util;

import cn.crane4j.core.exception.Crane4jException;
import java.util.Objects;

public class ClassUtils {
    public static boolean isJdkClass(Class<?> clazz) {
        Objects.requireNonNull(clazz, "class name must not null");
        Package objectPackage = clazz.getPackage();
        if (Objects.isNull(objectPackage)) {
            return false;
        }
        String objectPackageName = objectPackage.getName();
        return objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || clazz.getClassLoader() == null;
    }

    public static Class<?> forName(String className) throws Crane4jException {
        Objects.requireNonNull(className, "class name must not null");
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new Crane4jException(e);
        }
    }

    public static String packageToPath(String packagePath) {
        Objects.requireNonNull(packagePath, "packagePath must not null");
        return packagePath.replace(".", "/");
    }

    private ClassUtils() {
    }
}

