/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.cache;

import cn.crane4j.core.util.CollectionUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface CacheObject<K> {
    public String getName();

    public boolean isInvalid();

    public @Nullable Object get(K var1);

    default public Map<K, Object> getAll(Iterable<K> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptyMap();
        }
        HashMap results = new HashMap(16);
        keys.forEach(key -> {
            Object value = this.get(key);
            if (Objects.nonNull(value)) {
                results.put(key, value);
            }
        });
        return results;
    }

    public void put(K var1, Object var2);

    default public void putAll(Map<K, Object> caches) {
        if (CollectionUtils.isEmpty(caches)) {
            return;
        }
        caches.forEach(this::put);
    }

    public void putIfAbsent(K var1, Object var2);

    public void remove(K var1);

    default public void removeAll(Iterable<K> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        keys.forEach(this::remove);
    }

    public void clear();
}

